/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.util;

import cn.com.yusys.yusp.commons.module.adapter.query.PageQuery;
import cn.com.yusys.yusp.commons.module.adapter.query.QueryModel;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class MybatisPlusUtils {
    private static final IPage<?> EMPTY_PAGE = new Page();

    private MybatisPlusUtils() {
    }

    public static <T> Wrapper<T> lambdaQuery(Map<String, Object> maps) {
        return MybatisPlusUtils.lambdaQuery(Wrappers.query(), maps);
    }

    public static <T> Wrapper<T> lambdaQuery(AbstractWrapper<T, String, ?> wrapper, Map<String, Object> queryMap) {
        for (Map.Entry<String, Object> entry : queryMap.entrySet()) {
            String key = entry.getKey();
            Object val = queryMap.get(key);
            if (val == null || !(val instanceof String)) continue;
            String valString = String.valueOf(val);
            if (valString.startsWith("%")) {
                if (valString.endsWith("%")) {
                    wrapper.like((Object)StringUtils.underLine((String)key), (Object)StringUtils.substring((String)valString, (int)1, (int)(valString.length() - 2)));
                    continue;
                }
                wrapper.likeLeft((Object)StringUtils.underLine((String)key), (Object)StringUtils.substring((String)valString, (int)1, (int)(valString.length() - 1)));
                continue;
            }
            if (valString.endsWith("%")) {
                wrapper.likeRight((Object)StringUtils.underLine((String)key), (Object)StringUtils.substring((String)valString, (int)0, (int)(valString.length() - 1)));
                continue;
            }
            wrapper.eq((Object)StringUtils.underLine((String)key), queryMap.get(key));
        }
        return wrapper;
    }

    public static <T> IPage<T> ofPage(long page, long size) {
        return new Page(page, size);
    }

    public static <T, E extends IPage<T>> E ofPage(PageQuery pageQuery) {
        long pageNum = Objects.isNull(pageQuery.getPage()) || pageQuery.getPage() < 1L ? 1L : pageQuery.getPage();
        long pageSize = Objects.isNull(pageQuery.getSize()) || pageQuery.getSize() > 10000L ? 10000L : pageQuery.getSize();
        return (E)new Page(pageNum, pageSize);
    }

    public static <T> IPage<T> ofPage(QueryModel model) {
        if (Objects.nonNull(model)) {
            return new Page((long)model.getPage(), (long)model.getSize());
        }
        return new Page();
    }

    public static <T> Wrapper<T> pageQueryWrapper(Object object) {
        if (Objects.isNull(object)) {
            return Wrappers.emptyWrapper();
        }
        Class stopClassType = object instanceof PageQuery ? PageQuery.class : Object.class;
        List fieldList = null;
        try {
            fieldList = ReflectionUtils.getFields(object.getClass(), stopClassType);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        HashMap params = new HashMap(fieldList.size());
        fieldList.forEach(field -> params.put(field.getName(), ReflectionUtils.getPropertyValue((Object)object, (Field)field)));
        Wrapper<T> wrapper = MybatisPlusUtils.lambdaQuery(CollectionUtils.removeNullValue(params));
        return ReflectionUtils.isAssignable(PageQuery.class, object.getClass()) ? MybatisPlusUtils.sortWrapper((PageQuery)object, wrapper) : wrapper;
    }

    public static <T> Wrapper<T> sortWrapper(Wrapper<T> wrapper, String sort) {
        if (wrapper instanceof QueryWrapper) {
            QueryWrapper queryWrapper = (QueryWrapper)wrapper;
            if (StringUtils.nonEmpty((CharSequence)sort)) {
                String[] sorts = StringUtils.split((String)sort, (String)",");
                Arrays.stream(sorts).filter(StringUtils::nonEmpty).map(s -> StringUtils.split((String)s, (String)" ")).filter(ArrayUtils::nonEmpty).forEach(s -> {
                    if (((String[])s).length == 1) {
                        queryWrapper.orderByDesc((Object)StringUtils.delimiter((String)s[0], (String)"_"));
                    } else if (((String[])s).length == 2) {
                        if ("asc".equals(StringUtils.lowerCase((String)s[1]))) {
                            queryWrapper.orderByAsc((Object)StringUtils.delimiter((String)s[0], (String)"_"));
                        } else {
                            queryWrapper.orderByDesc((Object)StringUtils.delimiter((String)s[0], (String)"_"));
                        }
                    }
                });
            }
        }
        return wrapper;
    }

    public static <T> Wrapper<T> sortWrapper(PageQuery pageQuery, Wrapper<T> wrapper) {
        return MybatisPlusUtils.sortWrapper(wrapper, pageQuery.getSort());
    }

    public static <T, E extends IPage<T>> E emptyPage() {
        return (E)EMPTY_PAGE;
    }
}

