/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.type;

import cn.com.yusys.yusp.commons.mybatisplus.type.TypeHandler;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={java.sql.Date.class})
public class SqlDateTypeHandler
extends org.apache.ibatis.type.SqlDateTypeHandler
implements TypeHandler {
    private final DateTimeFormatter formatter;
    private final ZoneId zoneId;

    public SqlDateTypeHandler(String pattern, String timeZone) {
        this.formatter = DateTimeFormatter.ofPattern(pattern);
        this.zoneId = ZoneId.of(timeZone);
    }

    public void setNonNullParameter(PreparedStatement ps, int i, java.sql.Date parameter, JdbcType jdbcType) throws SQLException {
        if (JdbcType.VARCHAR.equals((Object)jdbcType)) {
            ps.setString(i, LocalDateTime.ofInstant(parameter.toInstant(), this.zoneId).format(this.formatter));
        } else {
            super.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    public java.sql.Date getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getNullableResult(rs, this.getColumnIndex(rs, columnName));
    }

    public java.sql.Date getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (this.isVarcharColumnType(rs, columnIndex)) {
            String value = rs.getString(columnIndex);
            return StringUtils.nonEmpty((CharSequence)value) ? new java.sql.Date(Date.from(LocalDateTime.parse(value, this.formatter).atZone(this.zoneId).toInstant()).getTime()) : null;
        }
        return super.getNullableResult(rs, columnIndex);
    }

    public java.sql.Date getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (this.isVarcharColumnType(cs, columnIndex)) {
            String value = cs.getString(columnIndex);
            return StringUtils.nonEmpty((CharSequence)value) ? new java.sql.Date(Date.from(LocalDateTime.parse(value, this.formatter).atZone(this.zoneId).toInstant()).getTime()) : null;
        }
        return super.getNullableResult(cs, columnIndex);
    }
}

