/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.type;

import cn.com.yusys.yusp.commons.mybatisplus.type.TypeHandler;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={LocalDate.class})
public class LocalDateTypeHandler
extends org.apache.ibatis.type.LocalDateTypeHandler
implements TypeHandler {
    private final DateTimeFormatter formatter;

    public LocalDateTypeHandler(String pattern, String timeZone) {
        this.formatter = DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of(timeZone));
    }

    public void setNonNullParameter(PreparedStatement ps, int i, LocalDate parameter, JdbcType jdbcType) throws SQLException {
        if (JdbcType.VARCHAR.equals((Object)jdbcType)) {
            ps.setString(i, parameter.format(this.formatter));
        } else {
            super.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    public LocalDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getNullableResult(rs, this.getColumnIndex(rs, columnName));
    }

    public LocalDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (this.isVarcharColumnType(rs, columnIndex)) {
            String value = rs.getString(columnIndex);
            return StringUtils.nonEmpty((CharSequence)value) ? LocalDate.parse(value, this.formatter) : null;
        }
        return super.getNullableResult(rs, columnIndex);
    }

    public LocalDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (this.isVarcharColumnType(cs, columnIndex)) {
            String value = cs.getString(columnIndex);
            return StringUtils.nonEmpty((CharSequence)value) ? LocalDate.parse(value, this.formatter) : null;
        }
        return super.getNullableResult(cs, columnIndex);
    }
}

