/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.injector;

import cn.com.yusys.yusp.commons.mybatisplus.injector.ICustomSqlInjector;
import cn.com.yusys.yusp.commons.mybatisplus.injector.SqlInjectorExtension;
import cn.com.yusys.yusp.commons.util.CommonUtils;
import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.AbstractSqlInjector;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicSqlInjectorExtension
extends AbstractSqlInjector
implements SqlInjectorExtension {
    private static final Logger logger = LoggerFactory.getLogger(DynamicSqlInjectorExtension.class);
    private final List<ICustomSqlInjector> INJECTORS;

    public DynamicSqlInjectorExtension(List<ICustomSqlInjector> injectors) {
        this.INJECTORS = injectors;
    }

    public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
        Class modelClass = this.extractModelClass(mapperClass);
        if (modelClass != null) {
            this.modelClassValidate(modelClass);
            String className = mapperClass.toString();
            Set mapperRegistryCache = GlobalConfigUtils.getMapperRegistryCache((Configuration)builderAssistant.getConfiguration());
            if (!mapperRegistryCache.contains(className)) {
                List<AbstractMethod> methodList = this.getMethodList(mapperClass, builderAssistant.getConfiguration());
                methodList.addAll(this.getMethodList(mapperClass));
                if (CollectionUtils.isNotEmpty(methodList)) {
                    TableInfo tableInfo = TableInfoHelper.initTableInfo((MapperBuilderAssistant)builderAssistant, (Class)modelClass);
                    methodList.forEach(m -> m.inject(builderAssistant, mapperClass, modelClass, tableInfo));
                } else {
                    logger.debug(mapperClass.toString() + ", No effective injection method was found.");
                }
                mapperRegistryCache.add(className);
            }
        }
    }

    public List<AbstractMethod> getMethodList(Class<?> mapperClass) {
        LinkedList<AbstractMethod> methods = new LinkedList<AbstractMethod>();
        if (CommonUtils.nonNullOrEmpty(this.INJECTORS)) {
            for (ICustomSqlInjector sqlInjector : this.INJECTORS) {
                if (!sqlInjector.isSupported(mapperClass)) continue;
                methods.addAll(sqlInjector.getMethodList(mapperClass));
            }
        }
        return methods;
    }

    private List<AbstractMethod> getMethodList(Class<?> mapperClass, Configuration configuration) {
        List<String> dynamicMethod = this.getDynamicSqlMethods(mapperClass, configuration);
        return METHOD_MAPPING.entrySet().stream().filter(entry -> dynamicMethod.contains(entry.getKey())).map(entry -> this.debugLogger(mapperClass, (Map.Entry<String, AbstractMethod>)entry)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private Map.Entry<String, AbstractMethod> debugLogger(Class<?> mapperClass, Map.Entry<String, AbstractMethod> entry) {
        if (logger.isDebugEnabled()) {
            logger.debug("Mapper[{}] while create dynamic sql method is:{}", mapperClass, (Object)entry.getKey());
        }
        return entry;
    }

    private List<String> getDynamicSqlMethods(Class<?> mapperClass, Configuration configuration) {
        return Stream.of(mapperClass.getMethods()).map(Method::getName).map(name -> name.indexOf(".") != -1 ? name.substring(name.lastIndexOf(".") + 1) : name).filter(name -> !configuration.getMappedStatementNames().contains(name)).filter(name -> METHOD_MAPPING.containsKey(name)).collect(Collectors.toList());
    }
}

