/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mybatisplus.type;

import cn.com.yusys.yusp.commons.mybatisplus.type.TypeHandler;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={LocalDateTime.class})
public class LocalDateTimeTypeHandler
extends org.apache.ibatis.type.LocalDateTimeTypeHandler
implements TypeHandler {
    private final DateTimeFormatter formatter;

    public LocalDateTimeTypeHandler(String pattern, String timeZone) {
        this.formatter = DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of(timeZone));
    }

    public void setNonNullParameter(PreparedStatement ps, int i, LocalDateTime parameter, JdbcType jdbcType) throws SQLException {
        if (JdbcType.VARCHAR.equals((Object)jdbcType)) {
            ps.setString(i, parameter.format(this.formatter));
        } else {
            super.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    public LocalDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getNullableResult(rs, this.getColumnIndex(rs, columnName));
    }

    public LocalDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        if (this.isVarcharColumnType(rs, columnIndex)) {
            String value = rs.getString(columnIndex);
            return StringUtils.nonEmpty((CharSequence)value) ? LocalDateTime.parse(value, this.formatter) : null;
        }
        return super.getNullableResult(rs, columnIndex);
    }

    public LocalDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        if (this.isVarcharColumnType(cs, columnIndex)) {
            String value = cs.getString(columnIndex);
            return StringUtils.nonEmpty((CharSequence)value) ? LocalDateTime.parse(value, this.formatter) : null;
        }
        return super.getNullableResult(cs, columnIndex);
    }
}

