/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ObjectMapperUtils {
    private static ObjectMapper INSTANCE;
    public static ThreadLocal<Boolean> USEING;

    private static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = (ObjectMapper)SpringContextUtils.getBeanProvider(ObjectMapper.class).getIfAvailable(ObjectMapper::new);
        }
    }

    public static ObjectMapper instance() {
        if (INSTANCE == null) {
            ObjectMapperUtils.init();
        }
        return INSTANCE;
    }

    public static String toJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            USEING.set(true);
            String string = ObjectMapperUtils.instance().writeValueAsString(object);
            return string;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        finally {
            USEING.remove();
        }
    }

    public static <T> T toObject(String json, Class<T> classType) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            USEING.set(true);
            Object object = ObjectMapperUtils.instance().readValue(json, classType);
            return (T)object;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        finally {
            USEING.remove();
        }
    }

    static {
        USEING = new ThreadLocal();
    }
}

