/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class NetUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetUtils.class);
    public static final String LOCALHOST = "127.0.0.1";
    private static final String FAILED_TO_RETRIVING_IP_ADDRESS = "Failed to retriving ip address";
    private static final String ANYHOST = "0.0.0.0";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static InetAddress localAddress;

    private NetUtils() {
    }

    @Nullable
    public static InetAddress getLocalAddress() {
        if (localAddress != null) {
            return localAddress;
        }
        localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    @NonNull
    public static String getLocalIpAddress() {
        return Optional.ofNullable(NetUtils.getLocalAddress()).map(InetAddress::getHostAddress).orElse(LOCALHOST);
    }

    public static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !LOCALHOST.equals(name) && IP_PATTERN.matcher(name).matches();
    }

    private static InetAddress getLocalAddress0() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Exception e) {
            logger.warn(FAILED_TO_RETRIVING_IP_ADDRESS, (Throwable)e);
        }
        return NetUtils.getAddressByNetwork();
    }

    private static InetAddress getAddressByNetwork() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (Objects.isNull(interfaces)) {
                return null;
            }
            return NetUtils.getAddressByInterfaces(interfaces);
        }
        catch (Exception e) {
            logger.warn(FAILED_TO_RETRIVING_IP_ADDRESS, (Throwable)e);
            logger.error("Could not get local host ip address, will use 127.0.0.1 instead.");
            return null;
        }
    }

    private static InetAddress getAddressByInterfaces(Enumeration<NetworkInterface> interfaces) {
        while (interfaces.hasMoreElements()) {
            try {
                NetworkInterface network = interfaces.nextElement();
                InetAddress address = NetUtils.getAddressByNetworkInterface(network);
                if (!Objects.nonNull(address)) continue;
                return address;
            }
            catch (Exception e3) {
                logger.warn(FAILED_TO_RETRIVING_IP_ADDRESS, (Throwable)e3);
            }
        }
        return null;
    }

    private static InetAddress getAddressByNetworkInterface(NetworkInterface network) {
        Enumeration<InetAddress> addresses = network.getInetAddresses();
        while (addresses.hasMoreElements()) {
            try {
                InetAddress address = addresses.nextElement();
                if (!NetUtils.isValidAddress(address)) continue;
                return address;
            }
            catch (Exception e2) {
                logger.warn(FAILED_TO_RETRIVING_IP_ADDRESS, (Throwable)e2);
            }
        }
        return null;
    }
}

