/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log;

import cn.com.yusys.yusp.commons.biz.BizHandlerInterceptor;
import cn.com.yusys.yusp.commons.log.ApiLogHelper;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RestLogBizHandlerInterceptor
implements BizHandlerInterceptor {
    private final ApiLogHelper apiLogHelper;

    public RestLogBizHandlerInterceptor(ApiLogHelper apiLogHelper) {
        this.apiLogHelper = apiLogHelper;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        return this.apiLogHelper.logInvoke(this.getRequestUri(), invocation.getThis(), invocation.getMethod(), invocation.getArguments(), true);
    }

    protected String getRequestUri() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String uri = "";
        if (Objects.nonNull(requestAttributes)) {
            HttpServletRequest request = requestAttributes.getRequest();
            uri = request.getRequestURI();
        }
        return uri;
    }
}

