/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.base.asyncbatch;

import cn.com.yusys.yusp.commons.base.asyncbatch.AsyncBatchDto;
import cn.com.yusys.yusp.commons.base.asyncbatch.AsyncBatchInterface;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class AsyncBatchProcess
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncBatchProcess.class);
    private static LinkedBlockingQueue<AsyncBatchDto> queue = new LinkedBlockingQueue(1000000);
    private final int batchSize = 10;
    private final Thread sendThread;
    private volatile boolean running = false;

    public AsyncBatchProcess() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("async-Sender-Thread").build();
        this.sendThread = threadFactory.newThread(new SendThread(10));
        this.sendThread.setDaemon(true);
        this.sendThread.setName("async-Sender-Thread");
    }

    public void addData(AsyncBatchDto logData) {
        if (!queue.offer(logData)) {
            LOG.error("async log queue is full, unsend : {}", logData.getData());
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        this.running = true;
        this.sendThread.start();
        LOG.info("async thread started.");
    }

    public void destroy() throws Exception {
        this.running = false;
        this.sendThread.interrupt();
    }

    private void send(Class process, List<Object> datas) {
        AsyncBatchInterface p = (AsyncBatchInterface)SpringContextUtils.getBean(process);
        p.process(datas);
    }

    private class SendThread
    implements Runnable {
        private final Logger LOG = LoggerFactory.getLogger(SendThread.class);
        private final ArrayList<Object> buffer;
        private Class process = null;

        public SendThread(int batchSize) {
            this.buffer = new ArrayList(batchSize);
        }

        @Override
        public void run() {
            while (AsyncBatchProcess.this.running) {
                try {
                    this.doUpdateData();
                }
                catch (InterruptedException e) {
                    if (AsyncBatchProcess.this.running) {
                        this.LOG.error("process thread interrupted.", (Throwable)e);
                        continue;
                    }
                    Thread.currentThread().interrupt();
                }
            }
            this.LOG.info("process thread stopped.");
        }

        private void doUpdateData() throws InterruptedException {
            AsyncBatchDto logData;
            if (!this.buffer.isEmpty()) {
                AsyncBatchProcess.this.send(this.process, this.buffer);
                this.buffer.clear();
            }
            if ((logData = (AsyncBatchDto)queue.take()) != null) {
                this.process = logData.getProcess();
                this.buffer.add(logData.getData());
                while ((logData = (AsyncBatchDto)queue.poll()) != null) {
                    if (this.buffer.size() >= 10 || !logData.getProcess().equals(this.process)) {
                        AsyncBatchProcess.this.send(this.process, this.buffer);
                        this.buffer.clear();
                        this.process = logData.getProcess();
                    }
                    this.buffer.add(logData.getData());
                }
                if (!this.buffer.isEmpty()) {
                    AsyncBatchProcess.this.send(this.process, this.buffer);
                    this.buffer.clear();
                }
            }
        }
    }
}

