/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StreamUtils;

public class DataSourceUtils {
    public static final String EXECUTED_SQL_STATEMENT = "The executed SQL statement is:{}";
    public static final String INITIALIZATION_SCRIPT_CANNOT_NULL_OR_EMPTY = "Initialization script cannot null or empty!";
    private static final Logger logger = LoggerFactory.getLogger(DataSourceUtils.class);
    private static final Pattern JDBC_DIALECT_PATTERN = Pattern.compile(":(.*?):");
    private static final Pattern TABLE_NAME = Pattern.compile("\\$\\{tableName\\}");

    public static void createTable(String createScriptPrefix, String tableName) {
        JdbcTemplate jdbcTemplate = SpringContextUtils.getBean(JdbcTemplate.class);
        String createScript = StringUtils.builder0((Object[])new Object[]{createScriptPrefix, DataSourceUtils.dialect(jdbcTemplate.getDataSource()), ".sql"});
        try (InputStream inputStream = DataSourceUtils.class.getClassLoader().getResourceAsStream(createScript);){
            if (Objects.isNull(inputStream)) {
                logger.warn("Can't fetch create table script:{}.", (Object)createScript);
                return;
            }
            jdbcTemplate.execute(stmt -> {
                try {
                    String createSql = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    int count = stmt.executeUpdate(DataSourceUtils.replaceTableName(createSql, tableName));
                    logger.info("Initialization database success!");
                    return count;
                }
                catch (IOException e) {
                    logger.error("execute script failure!", (Throwable)e);
                    return null;
                }
            });
        }
        catch (IOException e) {
            logger.error("create Table failure!", (Throwable)e);
        }
    }

    public static boolean executeUpdateScript(String script) {
        Asserts.notEmpty((CharSequence)script, (Object[])new Object[]{INITIALIZATION_SCRIPT_CANNOT_NULL_OR_EMPTY});
        logger.info(EXECUTED_SQL_STATEMENT, (Object)script);
        JdbcTemplate jdbcTemplate = SpringContextUtils.getBean(JdbcTemplate.class);
        int executeResult = jdbcTemplate.update(script);
        return executeResult > 0;
    }

    public static boolean executeUpdateScript(DataSource dataSource, String script) {
        Asserts.notEmpty((CharSequence)script, (Object[])new Object[]{INITIALIZATION_SCRIPT_CANNOT_NULL_OR_EMPTY});
        logger.info(EXECUTED_SQL_STATEMENT, (Object)script);
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        int executeResult = jdbcTemplate.update(script);
        return executeResult > 0;
    }

    public static String dialect(DataSource dataSource) {
        Matcher matcher = JDBC_DIALECT_PATTERN.matcher(DataSourceUtils.getUrl(dataSource));
        return matcher.find() ? matcher.group(1) : null;
    }

    public static String getUrl(DataSource dataSource) {
        Connection connection = null;
        try {
            connection = org.springframework.jdbc.datasource.DataSourceUtils.getConnection((DataSource)dataSource);
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
        }
    }

    public static String dialect(Connection connection, boolean isClose) {
        try {
            Matcher matcher = JDBC_DIALECT_PATTERN.matcher(connection.getMetaData().getURL());
            String string = matcher.find() ? matcher.group(1) : null;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (isClose) {
                org.springframework.jdbc.datasource.DataSourceUtils.releaseConnection((Connection)connection, null);
            }
        }
    }

    private static String replaceTableName(String str, String tableName) {
        Matcher matcher = TABLE_NAME.matcher(str);
        return matcher.find() ? matcher.replaceAll(tableName) : str;
    }

    public static int executeQueryScript(String script) {
        JdbcTemplate jdbcTemplate = SpringContextUtils.getBean(JdbcTemplate.class);
        return DataSourceUtils.executeQueryScript(jdbcTemplate, script);
    }

    public static int executeQueryScript(DataSource dataSource, String script) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        return DataSourceUtils.executeQueryScript(jdbcTemplate, script);
    }

    public static int executeQueryScript(JdbcTemplate jdbcTemplate, String script) {
        Asserts.notEmpty((CharSequence)script, (Object[])new Object[]{INITIALIZATION_SCRIPT_CANNOT_NULL_OR_EMPTY});
        logger.info(EXECUTED_SQL_STATEMENT, (Object)script);
        return (Integer)Optional.ofNullable(jdbcTemplate.query(script, rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        })).orElse(0);
    }
}

