/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ObjectMapperUtils {
    private static ObjectMapper INSTANCE;

    private static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = (ObjectMapper)SpringContextUtils.getBeanProvider(ObjectMapper.class).getIfAvailable(ObjectMapper::new);
        }
    }

    public static ObjectMapper instance() {
        if (INSTANCE == null) {
            ObjectMapperUtils.init();
        }
        return INSTANCE;
    }

    public static String toJson(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return ObjectMapperUtils.instance().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> classType) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)ObjectMapperUtils.instance().readValue(json, classType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

