/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Objects;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.type.MethodMetadata;

public class BeanDefinitionUtils {
    public static String className(BeanDefinition definition) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        MethodMetadata methodMetadata;
        String className = definition.getBeanClassName();
        if (StringUtils.nonEmpty((CharSequence)className)) {
            return className;
        }
        if (definition instanceof AnnotatedBeanDefinition && Objects.nonNull(methodMetadata = (annotatedBeanDefinition = (AnnotatedBeanDefinition)definition).getFactoryMethodMetadata())) {
            return methodMetadata.getReturnTypeName();
        }
        return className;
    }

    public static boolean isAssignFrom(BeanDefinition definition, Class<?> parentClass) throws ClassNotFoundException {
        String className = BeanDefinitionUtils.className(definition);
        return StringUtils.nonEmpty((CharSequence)className) && parentClass.isAssignableFrom(Class.forName(className));
    }
}

