/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.log;

import cn.com.yusys.yusp.commons.module.Module;
import cn.com.yusys.yusp.commons.module.ModuleHelper;
import cn.com.yusys.yusp.commons.module.constant.DynamicFrameworks;
import cn.com.yusys.yusp.commons.module.log.LoggerLevelRefresher;
import cn.com.yusys.yusp.commons.util.Predicates;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class DebugLoggerHelper
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(DebugLoggerHelper.class);
    private static final Map<String, Boolean> debugs = new ConcurrentHashMap<String, Boolean>();
    public static final String LOGGER_TAG = "logging.level.*";
    private static final Predicate<String> LOGGER_PREDICATE = Predicates.regex((String)"logging.level.*");
    private static Environment environment;
    private static LogLevel DEFAULT_LEVEL;
    private static final String SPRING_CLOUD_ENV = "org.springframework.cloud.context.environment.EnvironmentChangeEvent";
    private static LoggerLevelRefresher refresher;

    public static synchronized void setRefresher(LoggerLevelRefresher refresher) {
        if (DebugLoggerHelper.refresher == null) {
            DebugLoggerHelper.refresher = refresher;
        }
    }

    public static void setEnvironment(Environment environment) {
        DebugLoggerHelper.environment = environment;
        DynamicFrameworks.appendDynamicKeys(LOGGER_TAG);
        DEFAULT_LEVEL = LogLevel.valueOf((String)environment.getProperty("logging.level.root", "INFO").toUpperCase());
    }

    public static void refreshAll() {
        ModuleHelper.modules().forEach(DebugLoggerHelper::refresh);
    }

    public static void refresh(Module module) {
        if (environment != null && module != null && StringUtils.nonEmpty((CharSequence)module.getPackagename()) && StringUtils.nonEmpty((CharSequence)module.getProperty().getLogger())) {
            String level = environment.getProperty(module.getPackagename());
            Boolean debug = (Boolean)environment.getProperty(module.getProperty().getLogger(), Boolean.class, (Object)false);
            debugs.put(module.getName(), debug);
            if (StringUtils.isEmpty((CharSequence)level)) {
                DebugLoggerHelper.refresh(module.getPackagename(), debug != false ? LogLevel.DEBUG : DEFAULT_LEVEL);
            }
        }
    }

    public static boolean refresh(String packageName, LogLevel level) {
        if (Objects.isNull(refresher)) {
            log.warn("LoggerLevelRefresher not init");
            return false;
        }
        log.debug("Refresh package:{} set LoggerLevel:{}", (Object)packageName, (Object)level);
        refresher.refresh(packageName, level);
        return true;
    }

    public static void refresh(String packageName) {
        Objects.requireNonNull(environment);
        String level = environment.getProperty(packageName);
        if (StringUtils.nonEmpty((CharSequence)level)) {
            DebugLoggerHelper.refresh(packageName, LogLevel.valueOf((String)level.toUpperCase()));
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (ClassUtils.isPresent((String)SPRING_CLOUD_ENV, null) && event instanceof EnvironmentChangeEvent) {
            Set changedKeys = ((EnvironmentChangeEvent)event).getKeys();
            DebugLoggerHelper.refreshLoggerChangeKeys(changedKeys);
            Set<Module> modules = this.changedModule(changedKeys, environment);
            if (!modules.isEmpty()) {
                modules.forEach(module -> DebugLoggerHelper.refresh(module.getPackagename(), (LogLevel)(debugs.get(module.getName()) != false ? LogLevel.DEBUG : null)));
            }
        }
    }

    private static void refreshLoggerChangeKeys(Set<String> changedKeys) {
        changedKeys.stream().filter(LOGGER_PREDICATE).forEach(DebugLoggerHelper::refresh);
    }

    private Set<Module> changedModule(Set<String> keys, Environment env) {
        LinkedHashSet<Module> changeModules = new LinkedHashSet<Module>(32);
        for (Module module : ModuleHelper.modules()) {
            if (!keys.contains(module.getProperty().getLogger())) continue;
            debugs.put(module.getName(), debugs.get(module.getName()) == false);
            changeModules.add(module);
        }
        return changeModules;
    }
}

