/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.trace.reporter;

import brave.handler.MutableSpan;
import cn.com.yusys.yusp.commons.log.common.util.LoggerSerializeUtils;
import cn.com.yusys.yusp.commons.log.trace.TraceLogger;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.brave.bridge.BraveFinishedSpan;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.exporter.SpanReporter;
import zipkin2.internal.JsonEscaper;

public class TracingLoggerReporter
implements SpanReporter {
    private static final Logger log = LoggerFactory.getLogger(TracingLoggerReporter.class);

    public void report(FinishedSpan span) {
        try {
            if (span instanceof BraveFinishedSpan) {
                MutableSpan mutableSpan = BraveFinishedSpan.toBrave((FinishedSpan)span);
                TraceLogger.info(this.span2Map(mutableSpan));
            }
        }
        catch (IOException e) {
            log.warn("record trace span info exception:{}", (Object)e.getMessage());
        }
    }

    Map<String, Object> span2Map(MutableSpan value) throws JsonProcessingException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("traceId", value.traceId());
        if (value.parentId() != null) {
            param.put("parentId", value.parentId());
        }
        param.put("id", value.id());
        if (value.kind() != null) {
            param.put("kind", value.kind().toString());
        }
        if (value.name() != null) {
            param.put("name", JsonEscaper.jsonEscape((CharSequence)value.name()));
        }
        if (value.startTimestamp() != 0L) {
            long timestamp = value.startTimestamp();
            param.put("timestamp", timestamp);
            long timestampMillis = Long.parseLong(String.valueOf(timestamp).substring(0, 13));
            param.put("timestampMillis", timestampMillis);
        }
        if (value.startTimestamp() != 0L && value.finishTimestamp() != 0L) {
            param.put("duration", value.finishTimestamp() - value.startTimestamp());
        }
        param.put("localEndpoint", this.writeEndPoint(value.localIp(), value.localPort(), value.localServiceName(), false));
        param.put("remoteEndpoint", this.writeEndPoint(value.remoteIp(), value.remotePort(), value.remoteServiceName(), false));
        if (!value.annotations().isEmpty()) {
            param.put("annotations", TracingLoggerReporter.writeAnnotations(value.annotations()));
        }
        if (!value.tags().isEmpty()) {
            param.put("tags", LoggerSerializeUtils.writeAsString((Object)value.tags()));
        }
        if (Boolean.TRUE.equals(value.debug())) {
            param.put("debug", true);
        }
        if (Boolean.TRUE.equals(value.shared())) {
            param.put("shared", true);
        }
        return param;
    }

    Map<String, Object> writeEndPoint(String ip, int port, String serviceName, boolean writeEmptyServiceName) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (Objects.isNull(serviceName)) {
            serviceName = "";
        }
        param.put("serviceName", serviceName);
        if (Objects.nonNull(ip)) {
            param.put("ip", ip);
        }
        if (port != 0) {
            param.put("port", port);
        }
        return param;
    }

    static List<Map<String, Object>> writeAnnotations(Collection<Map.Entry<Long, String>> annotations) {
        ArrayList<Map<String, Object>> anna = new ArrayList<Map<String, Object>>();
        for (Map.Entry<Long, String> annotation : annotations) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("timestamp", annotation.getKey());
            param.put("value", JsonEscaper.jsonEscape((CharSequence)annotation.getValue()));
            anna.add(param);
        }
        return anna;
    }
}

