/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.jvm.collect;

import cn.com.yusys.yusp.commons.log.common.collect.TimedCollector;
import cn.com.yusys.yusp.commons.log.jvm.JvmLogger;
import cn.com.yusys.yusp.commons.log.jvm.collect.LocalLogMetricsEndpoint;
import cn.com.yusys.yusp.commons.log.jvm.domain.ClassLoadingBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.CompilationBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.HeapMemoryUsage;
import cn.com.yusys.yusp.commons.log.jvm.domain.JvmMonitorEntity;
import cn.com.yusys.yusp.commons.log.jvm.domain.MemoryBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.NonHeapMemoryUsage;
import cn.com.yusys.yusp.commons.log.jvm.domain.OperatingSystemBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.RuntimeBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.ThreadBean;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.alibaba.fastjson.JSON;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.health.HealthComponent;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class JvmTimedCollector
implements TimedCollector {
    private static final Logger log = LoggerFactory.getLogger(JvmTimedCollector.class);
    private final String cron;
    private final LocalLogMetricsEndpoint localLogMetricsEndpoint;
    private static JvmMonitorEntity jvmMonitorEntity = JvmMonitorEntity.getJvmMonitorEntityInstance();
    private static final ClassLoadingBean classLoadingBean = new ClassLoadingBean();
    private static final CompilationBean compilationBean = new CompilationBean();
    private static final OperatingSystemBean operatingSystemBean = new OperatingSystemBean();
    private static final RuntimeBean runtimeBean = new RuntimeBean();
    private static final ThreadBean threadBean = new ThreadBean();
    private static final MemoryBean memoryBean = new MemoryBean();
    private static final HeapMemoryUsage heapMemoryUsageBean = new HeapMemoryUsage();
    private static final NonHeapMemoryUsage nonHeapMemoryUsageBean = new NonHeapMemoryUsage();
    private static final ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private static final CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static final MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
    private static final MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();

    public JvmTimedCollector(String cron, LocalLogMetricsEndpoint localLogMetricsEndpoint) {
        this.cron = cron;
        this.localLogMetricsEndpoint = localLogMetricsEndpoint;
    }

    public Trigger getTrigger() {
        return new CronTrigger(this.cron);
    }

    public void run() {
        log.debug("begin to collect jvm  monitor data");
        JvmMonitorEntity jvmMonitorEntity = this.printJvmAllInfo();
        try {
            JvmLogger.info(jvmMonitorEntity);
        }
        catch (Exception e) {
            log.error("jvm monitor info get error", (Throwable)e);
        }
    }

    public JvmMonitorEntity printJvmAllInfo() {
        try {
            jvmMonitorEntity = this.printJvmInfo();
            if (jvmMonitorEntity != null) {
                Double processCpuUsage = this.localLogMetricsEndpoint.getMetricByProcessCpuUsage();
                jvmMonitorEntity.setProcessCpuUsage(processCpuUsage);
                Double systemCpuUsage = this.localLogMetricsEndpoint.getMetricBySystemCpuUsage();
                jvmMonitorEntity.setSystemCpuUsage(systemCpuUsage);
                MetricsEndpoint.MetricResponse gcMetricResponse = this.localLogMetricsEndpoint.getMetricByJvmGc();
                jvmMonitorEntity.setGcMetricResponse(gcMetricResponse);
                HealthComponent health = this.localLogMetricsEndpoint.getAppHealthStatus();
                jvmMonitorEntity.setHealth(JSON.toJSONString((Object)health));
                Map<String, Object> infoMap = this.localLogMetricsEndpoint.getAppInfo();
                jvmMonitorEntity.setInfoMap(infoMap);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return jvmMonitorEntity;
    }

    public JvmMonitorEntity printJvmInfo() {
        try {
            classLoadingBean.setLoadedClassCount(classLoadingMXBean.getLoadedClassCount());
            classLoadingBean.setTotalLoadedClassCount(classLoadingMXBean.getTotalLoadedClassCount());
            classLoadingBean.setUnloadedClassCount(classLoadingMXBean.getUnloadedClassCount());
            jvmMonitorEntity.setClassLoadingBean(classLoadingBean);
            compilationBean.setName(compilationMXBean.getName());
            if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
                compilationBean.setTotalCompilationTime(compilationMXBean.getTotalCompilationTime());
            }
            jvmMonitorEntity.setCompilationBean(compilationBean);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        try {
            Double systemLoadAverage = operatingSystemMXBean.getSystemLoadAverage();
            BeanUtils.copyProperties((Object)operatingSystemMXBean, (Object)operatingSystemBean);
            operatingSystemBean.setSystemLoadAverage(systemLoadAverage);
            long totalPhysicalMemorySize = JvmTimedCollector.getLongFromOperatingSystem(operatingSystemMXBean, "getTotalPhysicalMemorySize");
            long freePhysicalMemorySize = JvmTimedCollector.getLongFromOperatingSystem(operatingSystemMXBean, "getFreePhysicalMemorySize");
            long usedPhysicalMemorySize = totalPhysicalMemorySize - freePhysicalMemorySize;
            long totalSwapSpaceSize = JvmTimedCollector.getLongFromOperatingSystem(operatingSystemMXBean, "getTotalSwapSpaceSize");
            long freeSwapSpaceSize = JvmTimedCollector.getLongFromOperatingSystem(operatingSystemMXBean, "getFreeSwapSpaceSize");
            long usedSwapSpaceSize = totalSwapSpaceSize - freeSwapSpaceSize;
            operatingSystemBean.setTotalPhysicalMemorySize(totalPhysicalMemorySize);
            operatingSystemBean.setFreePhysicalMemorySize(freePhysicalMemorySize);
            operatingSystemBean.setUsedPhysicalMemorySize(usedPhysicalMemorySize);
            operatingSystemBean.setTotalSwapSpaceSize(totalSwapSpaceSize);
            operatingSystemBean.setUsedSwapSpaceSize(usedSwapSpaceSize);
            operatingSystemBean.setFreeSwapSpaceSize(freeSwapSpaceSize);
            jvmMonitorEntity.setOperatingSystemBean(operatingSystemBean);
            String pid = runtimeMXBean.getName().split("@")[0];
            if (StringUtils.nonEmpty((CharSequence)pid)) {
                runtimeBean.setProcessId(pid);
            }
            float processUsage = this.localLogMetricsEndpoint.getMetricByProcessCpuUsage().floatValue();
            runtimeBean.setProcessUsage(Float.valueOf(processUsage));
            BeanUtils.copyProperties((Object)runtimeMXBean, (Object)runtimeBean);
            runtimeBean.setInputArguments(JSON.toJSONString(runtimeMXBean.getInputArguments()));
            jvmMonitorEntity.setRuntimeBean(runtimeBean);
            BeanUtils.copyProperties((Object)threadMXBean, (Object)threadBean);
            jvmMonitorEntity.setThreadBean(threadBean);
        }
        catch (BeansException e) {
            log.error("", (Throwable)e);
        }
        BeanUtils.copyProperties((Object)heapMemoryUsage, (Object)heapMemoryUsageBean);
        BeanUtils.copyProperties((Object)nonHeapMemoryUsage, (Object)nonHeapMemoryUsageBean);
        try {
            Long userRate1 = heapMemoryUsage.getUsed() * 100L / heapMemoryUsage.getCommitted();
            heapMemoryUsageBean.setUserRate(userRate1);
            Long userRate2 = nonHeapMemoryUsage.getUsed() * 100L / nonHeapMemoryUsage.getCommitted();
            nonHeapMemoryUsageBean.setUserRate(userRate2);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        memoryBean.setHeapMemoryUsage(heapMemoryUsageBean);
        memoryBean.setNonHeapMemoryUsage(nonHeapMemoryUsageBean);
        jvmMonitorEntity.setMemoryBean(memoryBean);
        jvmMonitorEntity.setTimestamp(System.currentTimeMillis());
        return jvmMonitorEntity;
    }

    private static long getLongFromOperatingSystem(OperatingSystemMXBean operatingSystem, String methodName) {
        try {
            Method method = operatingSystem.getClass().getMethod(methodName, null);
            method.setAccessible(true);
            return (Long)method.invoke((Object)operatingSystem, (Object[])null);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

