/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.env.collect;

import cn.com.yusys.yusp.commons.log.common.collect.TimedCollector;
import cn.com.yusys.yusp.commons.log.env.EnvLogger;
import cn.com.yusys.yusp.commons.log.env.collect.LocalLogEnvAndConfigEndpoint;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class EnvTimedCollector
implements TimedCollector,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EnvTimedCollector.class);
    private final String cron;
    private final LocalLogEnvAndConfigEndpoint endpoint;

    public EnvTimedCollector(String cron, LocalLogEnvAndConfigEndpoint endpoint) {
        this.cron = cron;
        this.endpoint = endpoint;
    }

    public void afterPropertiesSet() throws Exception {
        this.run();
    }

    public Trigger getTrigger() {
        return new CronTrigger(this.cron);
    }

    public void run() {
        try {
            log.debug("Environment info begin collect!");
            Map<String, Object> result = this.endpoint.getEnvAndConfigDataMap();
            EnvLogger.info(result);
        }
        catch (Exception e) {
            log.error("env monitor info get error", (Throwable)e);
        }
    }
}

