/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.template;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.CloseCallBackInputStream;
import cn.com.yusys.yusp.commons.file.client.CloseCallBackUploadStream;
import cn.com.yusys.yusp.commons.file.util.FileInfoUtils;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class FileSystemTemplate {
    private final FileClient fileClient;
    private String defaultPath = "/";

    public FileSystemTemplate(FileClient fileClient) {
        this.fileClient = fileClient;
    }

    public FileClient getFileServer() {
        return this.fileClient;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath == null || defaultPath.startsWith("/") ? defaultPath : "/".concat(defaultPath);
    }

    protected FileClientCommand getFileServerCommand() {
        return this.fileClient.getCommand();
    }

    protected void closeFileServerCommand(FileClientCommand fileClientCommand) {
        if (fileClientCommand == null) {
            return;
        }
        try {
            fileClientCommand.close();
        }
        catch (IOException e) {
            throw new FileSystemException("Cannot close the fileCommand: " + fileClientCommand.toString(), e);
        }
    }

    protected String getRemotePath(String relativePath) {
        return StringUtils.nonEmpty((CharSequence)relativePath) ? FilePathUtils.concatRelativePath(this.defaultPath, relativePath) : this.defaultPath;
    }

    public boolean isFileExists(String remoteFileName) {
        return this.isFileExists(remoteFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileExists(String remoteFileName, String remoteRelativePath) {
        FileClientCommand command = null;
        FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        try {
            command = this.getFileServerCommand();
            boolean bl = command.isFileExists(remoteFileName, this.getRemotePath(remoteRelativePath));
            return bl;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFolderExists(String remoteRelativePath) {
        FileClientCommand command = null;
        Asserts.nonEmpty((CharSequence)remoteRelativePath, (Object[])new Object[]{"The file folder to be existed cannot be empty!"});
        try {
            command = this.getFileServerCommand();
            boolean bl = command.isFolderExists(this.getRemotePath(remoteRelativePath));
            return bl;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    public FileInfo queryFileInfo(String remoteFileName) {
        return this.queryFileInfo(remoteFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo queryFileInfo(String remoteFileName, String remoteRelativePath) {
        FileClientCommand command = null;
        FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        try {
            command = this.getFileServerCommand();
            FileInfo fileInfo = command.queryFileInfo(remoteFileName, this.getRemotePath(remoteRelativePath));
            return fileInfo;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInfo> queryFileInfoList(String remoteRelativePath) {
        FileClientCommand command = null;
        try {
            command = this.getFileServerCommand();
            List<FileInfo> list = command.queryFiles(this.getRemotePath(remoteRelativePath));
            return list;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> queryDirectoryList(String remoteRelativePath) {
        FileClientCommand command = null;
        try {
            command = this.getFileServerCommand();
            List<String> list = command.querySubFolder(this.getRemotePath(remoteRelativePath));
            return list;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    public FileInfo upload(String localFileName, String localPath) {
        return this.upload(localFileName, localPath, localFileName, null);
    }

    public FileInfo upload(String localFileName, String localPath, String remoteRelativePath) {
        return this.upload(localFileName, localPath, localFileName, remoteRelativePath);
    }

    public FileInfo upload(File localFile) {
        return this.upload(localFile.getName(), localFile.getParent(), localFile.getName(), null);
    }

    public FileInfo upload(File localFile, String remoteRelativePath) {
        return this.upload(localFile.getName(), localFile.getParent(), localFile.getName(), remoteRelativePath);
    }

    public FileInfo upload(File localFile, String remoteFileName, String remoteRelativePath) {
        return this.upload(localFile.getName(), localFile.getParent(), remoteFileName, remoteRelativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo upload(String localFileName, String localPath, String remoteFileName, String remoteRelativePath) {
        FileClientCommand command = null;
        FileInfoUtils.checkIfIllegalFileName(localFileName);
        File localFile = new File(StringUtils.builder0((Object[])new Object[]{localPath, File.separator, localFileName}));
        Asserts.isTrue((boolean)localFile.exists(), (Object[])new Object[]{"The local file that needs to be uploaded: %s must exist!", localFile.getAbsolutePath()});
        if (StringUtils.nonEmpty((CharSequence)remoteFileName)) {
            FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        }
        try {
            command = this.getFileServerCommand();
            FileInfo fileInfo = command.upload(localFileName, localPath, StringUtils.nonBlank((CharSequence)remoteFileName) ? remoteFileName : localFileName, this.getRemotePath(remoteRelativePath));
            return fileInfo;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    public boolean download(String localPath, String remoteFileName, String remoteRelativePath) {
        return this.download(remoteFileName, localPath, remoteFileName, remoteRelativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String localFileName, String localPath, String remoteFileName, String remoteRelativePath) {
        FileClientCommand command = null;
        FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        if (StringUtils.nonEmpty((CharSequence)localFileName)) {
            FileInfoUtils.checkIfIllegalFileName(localFileName);
        }
        try {
            command = this.getFileServerCommand();
            boolean bl = command.download(StringUtils.nonBlank((CharSequence)localFileName) ? localFileName : remoteFileName, localPath, remoteFileName, this.getRemotePath(remoteRelativePath));
            return bl;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    public boolean download(String localFileName, String localPath, FileInfo remoteFileInfo) {
        return FileInfoUtils.download(localFileName, localPath, remoteFileInfo);
    }

    public boolean deleteFile(FileInfo fileInfo) {
        return FileInfoUtils.deleteFile(fileInfo);
    }

    public boolean deleteFile(String remoteFileName) {
        return this.deleteFile(remoteFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String remoteFileName, String remoteRelativePath) {
        FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        FileClientCommand command = null;
        try {
            command = this.getFileServerCommand();
            boolean bl = command.delete(remoteFileName, this.getRemotePath(remoteRelativePath));
            return bl;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFolder(String remoteRelativePath) {
        FileClientCommand command = null;
        Asserts.nonEmpty((CharSequence)remoteRelativePath, (Object[])new Object[]{"The remote path to be deleted cannot be empty!"});
        try {
            command = this.getFileServerCommand();
            boolean bl = command.deleteFolder(this.getRemotePath(remoteRelativePath));
            return bl;
        }
        finally {
            this.closeFileServerCommand(command);
        }
    }

    public void copy(FileInfo srcFile, FileInfo targetFile, boolean isOverwrite) throws FileSystemException, IOException {
        FileInfoUtils.copy(srcFile, this.resetTargetFilePath(targetFile), isOverwrite);
    }

    private FileInfo resetTargetFilePath(FileInfo target) {
        if (target != null) {
            String targetPath = target.getFilePath();
            if (StringUtils.nonEmpty((CharSequence)targetPath)) {
                if (!targetPath.startsWith(this.defaultPath) && !('/' + targetPath).startsWith(this.defaultPath)) {
                    targetPath = this.getRemotePath(targetPath);
                }
            } else {
                targetPath = this.defaultPath;
            }
            target.setFilePath(targetPath);
        }
        return target;
    }

    public void move(FileInfo srcFile, FileInfo targetFile, boolean isOverwrite) throws FileSystemException, IOException {
        FileInfoUtils.move(srcFile, this.resetTargetFilePath(targetFile), isOverwrite);
    }

    public AbstractUploadStream openUploadStream(String remoteFileName, long size) throws FileSystemException {
        return this.openUploadStream(remoteFileName, null, size);
    }

    public AbstractUploadStream openUploadStream(String remoteFileName, String remoteRelativePath, long size) throws FileSystemException {
        FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        FileClientCommand command = this.fileClient.getCommand();
        AbstractUploadStream stream = command.openUploadStream(remoteFileName, this.getRemotePath(remoteRelativePath), size);
        return new CloseCallBackUploadStream(stream, command::close);
    }

    public InputStream openDownloadStream(String remoteFileName, String remoteRelativePath) throws FileSystemException {
        FileInfoUtils.checkIfIllegalFileName(remoteFileName);
        FileClientCommand command = this.fileClient.getCommand();
        InputStream stream = command.openDownloadStream(remoteFileName, this.getRemotePath(remoteRelativePath));
        return new CloseCallBackInputStream(stream, command::close);
    }

    public InputStream openDownloadStream(FileInfo fileInfo) throws FileSystemException {
        return FileInfoUtils.openDownloadStream(fileInfo);
    }
}

