/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.util;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.ArchiveOperateInfo;
import cn.com.yusys.yusp.commons.file.client.CloseCallBackInputStream;
import cn.com.yusys.yusp.commons.file.client.FileClientManager;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplate;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.util.encrypt.Base64;
import cn.com.yusys.yusp.commons.util.io.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SerializationUtils;

public final class FileInfoUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileInfoUtils.class);
    private static final Pattern ILLEGAL_FILE_NAME_PATTERN = Pattern.compile("\\\\|/|:|\\*|\\?|\\\"|<|>|\\|");
    private static final String TEMP_FILE_PREFIX = "yusp-file-";
    private static final AtomicBoolean IS_INIT = new AtomicBoolean(false);

    private FileInfoUtils() {
    }

    public static FileSystemTemplate temporaryFileSystemTemplate() {
        return (FileSystemTemplate)SpringContextUtils.getBean((String)"tmpFileTemplate");
    }

    public static String toIdentity(FileInfo fileInfo) {
        Asserts.nonNull((Object)fileInfo, (Object[])new Object[]{"File info must not null!"});
        String[] identityArray = new String[]{fileInfo.getFileServer().getServerId(), fileInfo.getFileName(), fileInfo.getFilePath()};
        byte[] content = SerializationUtils.serialize((Object)identityArray);
        return Base64.encodeBase64URLSafeString((byte[])content);
    }

    public static String toIdentity(FileInfo fileInfo, String fileDesc) {
        Asserts.nonNull((Object)fileInfo, (Object[])new Object[]{"File info must not null!"});
        String[] identityArray = new String[]{fileInfo.getFileServer().getServerId(), fileInfo.getFileName(), fileInfo.getFilePath(), fileDesc};
        byte[] content = SerializationUtils.serialize((Object)identityArray);
        return Base64.encodeBase64URLSafeString((byte[])content);
    }

    public static FileInfo fromIdentity(String identity) {
        FileInfo fileInfo;
        if (StringUtils.isEmpty((CharSequence)identity)) {
            throw new FileSystemException("File identity must not empty!");
        }
        FileClientCommand command = null;
        try {
            byte[] content = Base64.decodeBase64((String)identity);
            String[] identityArray = (String[])SerializationUtils.deserialize((byte[])content);
            FileClient fileClient = FileClientManager.getFileServer(identityArray[0]);
            command = fileClient.getCommand();
            fileInfo = command.queryFileInfo(identityArray[1], identityArray[2]);
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new FileSystemException(e);
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{command});
                throw throwable;
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{command});
        return fileInfo;
    }

    public static String fetchIdentityDesc(String identity) {
        Asserts.nonEmpty((CharSequence)identity, (Object[])new Object[]{"File id must not null!"});
        byte[] content = Base64.decodeBase64((String)identity);
        String[] identityArray = (String[])SerializationUtils.deserialize((byte[])content);
        if (identityArray.length > 3) {
            return identityArray[3];
        }
        return null;
    }

    private static void closeCommand(FileClientCommand command) {
        if (Objects.nonNull(command)) {
            try {
                command.close();
            }
            catch (IOException e) {
                throw new FileSystemException("Cannot close the command: " + command.toString(), e);
            }
        }
    }

    public static boolean deleteFile(FileInfo fileInfo) {
        FileClientCommand command = null;
        Asserts.nonNull((Object)fileInfo, (Object[])new Object[]{"The file info to be deleted cannot be null!"});
        FileInfoUtils.checkIfIllegalFileName(fileInfo.getFileName());
        try {
            command = fileInfo.getFileServer().getCommand();
            boolean bl = command.delete(fileInfo.getFileName(), fileInfo.getFilePath());
            return bl;
        }
        finally {
            FileInfoUtils.closeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void copyOrMove(FileInfo source, FileInfo target, boolean overwrite, boolean deleteSource, Function<FileClientCommand, T> operate) throws FileSystemException, IOException {
        block15: {
            Asserts.nonNull((Object)source, (Object[])new Object[]{"The original file information to be moved cannot be empty!"});
            Asserts.nonNull((Object)target, (Object[])new Object[]{"The target file information to be moved cannot be null!"});
            FileInfoUtils.checkIfIllegalFileName(source.getFileName());
            if (StringUtils.isEmpty((CharSequence)target.getFileName())) {
                target.setFileName(source.getFileName());
            } else {
                FileInfoUtils.checkIfIllegalFileName(target.getFileName());
            }
            Asserts.nonNull((Object)source.getFileServer(), (Object[])new Object[]{"The original file server must not null!"});
            Asserts.nonNull((Object)target.getFileServer(), (Object[])new Object[]{"the target file server must not null!"});
            if (!source.isExists()) {
                throw new FileSystemException(String.format("Source file:%s not found!", FilePathUtils.getAbsolutePath(source.getFilePath(), source.getFileName())));
            }
            if (source.getFileServer().equals(target.getFileServer())) {
                try (FileClientCommand sourceCommand = source.getFileServer().getCommand();){
                    operate.apply(sourceCommand);
                    logger.info("File operate success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{source.getFilePath(), source.getFileName(), target.getFilePath(), target.getFileName()});
                }
            }
            try {
                if (!FileInfoUtils.differentServerFileCopy(source, target, overwrite) || !deleteSource) break block15;
                try {
                    if (!source.getFileServer().getCommand().delete(source.getFileName(), source.getFilePath())) {
                        throw new FileSystemException("File delete failure!");
                    }
                    logger.info("source file path:{}, source file name:{} delete success!", (Object)source.getFilePath(), (Object)source.getFileName());
                }
                catch (FileSystemException e) {
                    logger.error(String.format("Source file:%s delete failure! cause by:%s", FilePathUtils.getAbsolutePath(source.getFilePath(), source.getFileName()), e.getMessage()));
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{source.getFileServer().getCommand(), target.getFileServer().getCommand()});
                throw throwable;
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{source.getFileServer().getCommand(), target.getFileServer().getCommand()});
    }

    @Deprecated
    public static void copy(FileInfo srcFile, FileInfo targetFile, boolean isOverwrite) throws FileSystemException, IOException {
        FileInfoUtils.copyOrMove(srcFile, targetFile, isOverwrite, false, command -> command.copy(srcFile.getFileName(), srcFile.getFilePath(), targetFile.getFileName(), targetFile.getFilePath(), isOverwrite));
    }

    public static void move(FileInfo srcFile, FileInfo targetFile, boolean isOverwrite) throws FileSystemException, IOException {
        FileInfoUtils.copyOrMove(srcFile, targetFile, isOverwrite, true, command -> command.move(srcFile.getFileName(), srcFile.getFilePath(), targetFile.getFileName(), targetFile.getFilePath(), isOverwrite));
    }

    private static boolean differentServerFileCopy(FileInfo source, FileInfo target, boolean overwrite) throws IOException {
        FileClientCommand srcCommand = source.getFileServer().getCommand();
        FileClientCommand targetCommand = target.getFileServer().getCommand();
        if (target.isExists()) {
            if (overwrite && targetCommand.delete(target.getFileName(), target.getFilePath())) {
                logger.info("The target file:{} exists but has been deleted", (Object)FilePathUtils.getAbsolutePath(target.getFilePath(), target.getFileName()));
            } else {
                throw new FileSystemException(String.format("Source file:%s exists, but overwrite is false or delete failure!", FilePathUtils.getAbsolutePath(target.getFilePath(), target.getFileName())));
            }
        }
        try (InputStream is = srcCommand.openDownloadStream(source.getFileName(), source.getFilePath());
             AbstractUploadStream os = targetCommand.openUploadStream(target.getFileName(), target.getFilePath(), source.getFileSize());){
            if (is == null) {
                throw new FileSystemException(String.format("The open download stream of the source file gets empty, source file server is:%s, file is:%s", source.getFileServer().getServerId(), FilePathUtils.concatFileName(source.getFilePath(), source.getFileName())));
            }
            if (os == null) {
                throw new FileSystemException(String.format("The open upload stream of the target file gets empty, target file server is:%s, file is:%s", target.getFileServer().getServerId(), FilePathUtils.concatFileName(target.getFilePath(), target.getFileName())));
            }
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        logger.info("File operate success! source file serverId is:{} source file path:{}, source file name:{} --> target file serverId is:{}, target file path:{}, target file name:{}", new Object[]{source.getFileServer().getServerId(), source.getFilePath(), source.getFileName(), target.getFileServer().getServerId(), target.getFilePath(), target.getFilePath()});
        return true;
    }

    public static InputStream openDownloadStream(FileInfo fileInfo) throws FileSystemException {
        Asserts.nonNull((Object)fileInfo, (Object[])new Object[]{"The file info to be downloaded cannot be null!"});
        FileInfoUtils.checkIfIllegalFileName(fileInfo.getFileName());
        FileClientCommand command = fileInfo.getFileServer().getCommand();
        InputStream stream = command.openDownloadStream(fileInfo.getFileName(), fileInfo.getFilePath());
        return new CloseCallBackInputStream(stream, command::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(String localFileName, String localPath, FileInfo fileInfo) throws FileSystemException {
        FileInfoUtils.checkIfIllegalFileName(fileInfo.getFileName());
        FileClientCommand command = fileInfo.getFileServer().getCommand();
        try {
            boolean bl = command.download(localFileName, localPath, fileInfo.getFileName(), fileInfo.getFilePath());
            return bl;
        }
        finally {
            FileInfoUtils.closeCommand(command);
        }
    }

    public static FileInfo createFileInfo(FileSystemTemplate fileSystemTemplate, String fileName, String filePath) {
        FileInfo targetFile = new FileInfo();
        targetFile.setFileName(fileName);
        if (!filePath.startsWith("/")) {
            filePath = File.separator + filePath;
        }
        targetFile.setFilePath(fileSystemTemplate.getDefaultPath() + filePath);
        targetFile.setFileServer(fileSystemTemplate.getFileServer());
        return targetFile;
    }

    public static FileInfo uploadTempFile(File file) {
        Asserts.isTrue((boolean)file.exists(), (Object[])new Object[]{"File must exist!"});
        FileSystemTemplate tmpFileTemplate = (FileSystemTemplate)SpringContextUtils.getBean((String)"tmpFileTemplate");
        return tmpFileTemplate.upload(file, FileInfoUtils.getTempFilePath());
    }

    public static String getTempFilePath() {
        return DateUtils.formatDate((String)"yyyyMMddHH");
    }

    private static ArchiveOperateInfo fileArchive(List<FileInfo> files, List<String> nonExists, FileSystemTemplate archiveTemplate, String archivePath, boolean deleteSource) {
        ArchiveOperateInfo info = new ArchiveOperateInfo();
        int successCount = 0;
        LinkedList<String> errors = new LinkedList<String>();
        if (CollectionUtils.nonEmpty(nonExists)) {
            List nonExistsFileError = nonExists.stream().map(file -> StringUtils.builder0((Object[])new Object[]{file, "---errorInfo[The src file is empty]"})).collect(Collectors.toList());
            errors.addAll(nonExistsFileError);
        }
        if (CollectionUtils.nonEmpty(files)) {
            for (FileInfo fileInfo : files) {
                FileInfo targetFile = FileInfoUtils.createFileInfo(archiveTemplate, fileInfo.getFileName(), archivePath);
                try {
                    if (deleteSource) {
                        FileInfoUtils.move(fileInfo, targetFile, true);
                    } else {
                        FileInfoUtils.copy(fileInfo, targetFile, true);
                    }
                    ++successCount;
                }
                catch (FileSystemException | IOException e) {
                    errors.add(StringUtils.builder0((Object[])new Object[]{fileInfo.getFilePath(), File.separator, fileInfo.getFileName(), "---errorInfo[", e.getMessage(), "]"}));
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        info.setArchiveErrors(errors);
        info.setArchiveSuccess(successCount);
        info.setArchiveTotal(Optional.ofNullable(info.getArchiveErrors()).map(List::size).orElse(0) + successCount);
        return info;
    }

    public static ArchiveOperateInfo archiveHistoryFile(FileSystemTemplate sourceFileTemplate, String sourceFilePath, FileSystemTemplate archiveTemplate, String archivePath, boolean deleteSource) {
        return FileInfoUtils.fileArchive(sourceFileTemplate.queryFileInfoList(sourceFilePath), null, archiveTemplate, archivePath, deleteSource);
    }

    public static ArchiveOperateInfo archiveHistoryFile(FileSystemTemplate sourceFileTemplate, List<String> sourceFileInfos, FileSystemTemplate archiveTemplate, String archivePath, boolean deleteSource) {
        if (sourceFileInfos != null && !sourceFileInfos.isEmpty()) {
            LinkedList<FileInfo> exists = new LinkedList<FileInfo>();
            LinkedList<String> nonExists = new LinkedList<String>();
            for (String sourceFile : sourceFileInfos) {
                int lastIndexOf = sourceFile.lastIndexOf(47);
                String filePath = sourceFile.substring(0, lastIndexOf);
                String fileName = sourceFile.substring(lastIndexOf + 1);
                boolean fileExists = sourceFileTemplate.isFileExists(fileName, filePath);
                if (fileExists) {
                    exists.add(sourceFileTemplate.queryFileInfo(fileName, filePath));
                    continue;
                }
                nonExists.add(sourceFile);
            }
            return FileInfoUtils.fileArchive(exists, nonExists, archiveTemplate, archivePath, deleteSource);
        }
        return new ArchiveOperateInfo();
    }

    public static void checkIfIllegalFileName(String fileName) {
        Asserts.nonEmpty((CharSequence)fileName, (Object[])new Object[]{"File name must not empty!"});
        Asserts.isFalse((boolean)ILLEGAL_FILE_NAME_PATTERN.matcher(fileName).find(), (Object[])new Object[]{"The following characters cannot exist in[%s] the file name!", "\\/:*?\"<>|", fileName});
        Asserts.isFalse((fileName.length() == StringUtils.countOccurrencesOf((String)fileName, (String)".") ? 1 : 0) != 0, (Object[])new Object[]{" The file name:%s cannot be all dots", fileName});
    }

    public static File createTempFile(String fileName) throws IOException {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return File.createTempFile(TEMP_FILE_PREFIX, null);
        }
        FileInfoUtils.checkIfIllegalFileName(fileName);
        int index = fileName.lastIndexOf(".");
        return index < 0 ? File.createTempFile(TEMP_FILE_PREFIX + fileName, null) : File.createTempFile(TEMP_FILE_PREFIX + fileName.substring(0, index), fileName.substring(index));
    }
}

