/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.template;

import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.template.DefaultFileSystemTemplate;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplate;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.FactoryBean;

public class FileSystemTemplateFactory
implements FactoryBean<FileSystemTemplate> {
    private final FileClient fileClient;
    private final List<FileSystemTemplateRegister> registers;
    private final String defaultPath;

    public FileSystemTemplateFactory(FileClient fileClient, List<FileSystemTemplateRegister> registers, String defaultPath) {
        this.fileClient = fileClient;
        this.registers = registers;
        this.defaultPath = defaultPath;
    }

    public FileSystemTemplate getObject() {
        FileSystemTemplateRegister register;
        FileSystemTemplate fileSystemTemplate = null;
        Iterator<FileSystemTemplateRegister> iterator = this.registers.iterator();
        while (iterator.hasNext() && (fileSystemTemplate = (register = iterator.next()).getFileSystemTemplate(this.fileClient)) == null) {
        }
        fileSystemTemplate = Optional.ofNullable(fileSystemTemplate).orElseGet(() -> new DefaultFileSystemTemplate(this.fileClient));
        fileSystemTemplate.setDefaultPath(this.defaultPath);
        return fileSystemTemplate;
    }

    public Class<?> getObjectType() {
        return FileSystemTemplate.class;
    }
}

