/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileInfo;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractDefaultOutputStream
extends AbstractUploadStream {
    private OutputStream innerStream = null;
    private FileInfo uploadedFile;
    private long maxSize;
    private long sendSize = 0L;

    public AbstractDefaultOutputStream(OutputStream outputStream, long maxSize) {
        this.innerStream = outputStream;
        this.maxSize = maxSize;
    }

    @Override
    public void write(int b) throws IOException {
        this.innerStream.write(b);
        ++this.sendSize;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.innerStream.write(b, off, len);
        this.sendSize += (long)(len - off);
    }

    @Override
    public void flush() throws IOException {
        this.innerStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.maxSize != this.sendSize) {
            this.closeError(this.innerStream);
            throw new IOException("Sent data length is not match the size.");
        }
        this.uploadedFile = this.closeSuccess(this.innerStream);
    }

    @Override
    public FileInfo getUploadedFile() {
        return this.uploadedFile;
    }

    protected OutputStream getInnerStream() {
        return this.innerStream;
    }

    protected long getSendSize() {
        return this.sendSize;
    }

    protected long getMaxSize() {
        return this.maxSize;
    }

    protected abstract void closeError(OutputStream var1) throws IOException;

    protected abstract FileInfo closeSuccess(OutputStream var1) throws IOException;
}

