/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.tencentcos;

import cn.com.yusys.yusp.commons.file.client.tencentcos.CosConfig;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosConnectConfig;
import cn.com.yusys.yusp.commons.file.client.tencentcos.InstantiationCosClientPostProcessor;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.BasicSessionCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.InstanceProfileCredentials;
import com.qcloud.cos.model.Bucket;
import com.qcloud.cos.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosClientPostProcessor
implements InstantiationCosClientPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCosClientPostProcessor.class);

    @Override
    public COSCredentials postProcessCosCredentialsBeforeInstantiation(COSCredentials cosCredentials, CosConnectConfig cosConnectConfig) {
        return this.buildCosCredentials(cosCredentials, cosConnectConfig);
    }

    @Override
    public ClientConfig postProcessClientConfigBeforeInstantiation(ClientConfig clientConfig, CosConnectConfig cosConnectConfig) {
        return this.buildClientConfig(clientConfig, cosConnectConfig);
    }

    @Override
    public void postProcessCosClientAfterInstantiation(COSClient client, CosConnectConfig cosConnectConfig) {
        if (client.doesBucketExist(cosConnectConfig.getBucketName())) {
            Bucket bucket = client.createBucket(cosConnectConfig.getBucketName());
            logger.info("Current config bucket:{} don`t exist, has create, created information is:{}", (Object)cosConnectConfig.getBucketName(), (Object)bucket);
        }
    }

    private COSCredentials buildCosCredentials(COSCredentials cosCredentials, CosConnectConfig cosConnectConfig) {
        CosConfig.Secret secret = cosConnectConfig.getSecret();
        switch (secret.getAuthorizationType()) {
            case BASIC: {
                cosCredentials = new BasicCOSCredentials(secret.getAccessKey(), secret.getSecretKey());
                break;
            }
            case PROFILE: {
                cosCredentials = new InstanceProfileCredentials(secret.getAccessKey(), secret.getSecretKey(), secret.getSessionToken(), secret.getSessionExpiredTime().longValue());
                break;
            }
            case SESSION: {
                cosCredentials = new BasicSessionCredentials(secret.getAccessKey(), secret.getSecretKey(), secret.getSessionToken());
                break;
            }
            default: {
                cosCredentials = new AnonymousCOSCredentials();
            }
        }
        return cosCredentials;
    }

    protected ClientConfig buildClientConfig(ClientConfig clientConfig, CosConnectConfig cosConnectConfig) {
        Class retryPolicyClassType;
        CosConfig.Http http = cosConnectConfig.getHttp();
        if (http.isUserProxy()) {
            clientConfig.setHttpProxyIp(http.getProxyIp());
            clientConfig.setHttpProxyPort(http.getProxyPort());
            clientConfig.setProxyUsername(http.getProxyUsername());
            clientConfig.setProxyPassword(http.getProxyPassword());
        }
        clientConfig.setHttpProtocol(http.getProtocolType());
        clientConfig.setConnectionTimeout(http.getConnectionTimeout());
        clientConfig.setConnectionRequestTimeout(http.getConnectionRequestTimeout());
        clientConfig.setSocketTimeout(http.getSocketTimeout());
        clientConfig.setMaxConnectionsCount(http.getMaxConnectionsCount());
        clientConfig.setMaxErrorRetry(cosConnectConfig.getRetry().getMaxErrorRetry());
        if (StringUtils.nonEmpty((CharSequence)cosConnectConfig.getRetry().getRetryPolicy()) && ReflectionUtils.isPresent((String)cosConnectConfig.getRetry().getRetryPolicy()) && ReflectionUtils.isAssignable((Class)(retryPolicyClassType = ReflectionUtils.forName((String)cosConnectConfig.getRetry().getRetryPolicy())), RetryPolicy.class)) {
            clientConfig.setRetryPolicy((RetryPolicy)BeanUtils.newInstance((String)cosConnectConfig.getRetry().getRetryPolicy()));
        }
        return clientConfig;
    }
}

