/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.tencentcos;

import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.client.AbstractFileClient;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosConnectConfig;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosFileClientCommand;
import cn.com.yusys.yusp.commons.file.client.tencentcos.InstantiationCosClientPostProcessor;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.AnonymousCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class CosFileClient
extends AbstractFileClient<CosConnectConfig> {
    public static final String TENCENT_COS_FILE_SYSTEM_TYPE = "TENCENT-COS";
    private COSClient client;
    private final List<InstantiationCosClientPostProcessor> postProcessors;

    public CosFileClient(String clientId, CosConnectConfig cosConnectConfig, GenericObjectPoolConfig<FileClientCommand> poolConfig, List<InstantiationCosClientPostProcessor> postProcessors) {
        super(clientId, (ConnectConfig)cosConnectConfig, poolConfig);
        this.postProcessors = postProcessors;
    }

    public String getFileSystemType() {
        return TENCENT_COS_FILE_SYSTEM_TYPE;
    }

    private void initCosClient() {
        AnonymousCOSCredentials credentials = new AnonymousCOSCredentials();
        ClientConfig clientConfig = new ClientConfig();
        if (CollectionUtils.nonEmpty(this.postProcessors)) {
            for (InstantiationCosClientPostProcessor postProcessor2 : this.postProcessors) {
                credentials = postProcessor2.postProcessCosCredentialsBeforeInstantiation((COSCredentials)credentials, (CosConnectConfig)super.getConnectConfig());
                clientConfig = postProcessor2.postProcessClientConfigBeforeInstantiation(clientConfig, (CosConnectConfig)super.getConnectConfig());
            }
        }
        COSClient cosClient = new COSClient((COSCredentials)credentials, clientConfig);
        if (CollectionUtils.nonEmpty(this.postProcessors)) {
            this.postProcessors.forEach(postProcessor -> postProcessor.postProcessCosClientAfterInstantiation(cosClient, (CosConnectConfig)super.getConnectConfig()));
        }
        this.client = cosClient;
    }

    public void afterPropertiesSet() throws Exception {
        this.initCosClient();
        super.afterPropertiesSet();
    }

    protected FileClientCommand createCommand(CosConnectConfig cosConnectConfig) {
        return new CosFileClientCommand(this, cosConnectConfig.getBucketName());
    }

    public COSClient client() {
        return this.client;
    }

    public void destroy() {
        super.destroy();
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

