/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.localdisk;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.AbstractDefaultOutputStream;
import cn.com.yusys.yusp.commons.file.client.localdisk.LocalDiskFileClient;
import cn.com.yusys.yusp.commons.file.client.localdisk.LocalDiskFileInfo;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiskFileClientCommand
implements FileClientCommand {
    private static final Logger logger = LoggerFactory.getLogger(LocalDiskFileClientCommand.class);
    private final LocalDiskFileClient fileClient;

    public LocalDiskFileClientCommand(LocalDiskFileClient fileClient) {
        this.fileClient = fileClient;
    }

    public void close() {
    }

    public FileInfo upload(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        File remoteFile;
        File localFile = this.getLocalFile(localFileName, localPath, false);
        if (this.copy(localFile, remoteFile = this.getLocalFile(remoteFileName, remotePath, true), true)) {
            return this.queryFileInfo(remoteFileName, remotePath);
        }
        throw new FileSystemException(String.format("local server upload file failure! localPath: %s, localFileName: %s, remotePath: %s, remoteFileName: %s", localPath, localFileName, remotePath, remoteFileName));
    }

    public boolean download(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        File localFile = this.getLocalFile(localFileName, localPath, false);
        File remoteFile = this.getLocalFile(remoteFileName, remotePath, true);
        return this.copy(remoteFile, localFile, true);
    }

    public AbstractUploadStream openUploadStream(String fileName, String remotePath, long size) throws FileSystemException {
        File localFile = this.getLocalFile(fileName, remotePath, true);
        if (localFile.exists()) {
            if (localFile.delete()) {
                logger.debug("file:{} delete success!", (Object)localFile.getAbsolutePath());
            }
        } else {
            try {
                FileUtils.forceMkdirParent((File)localFile);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage(), (Throwable)e);
            }
        }
        FileInfo fileInfo = this.createFileInfo(localFile, fileName, remotePath);
        FileOutputStream outStream = null;
        try {
            outStream = FileUtils.openOutputStream((File)localFile);
            return new LocalDiskOutputStream(localFile, outStream, fileInfo, size);
        }
        catch (IOException | RuntimeException e) {
            FileSystemException fsex = new FileSystemException(e.getMessage(), (Throwable)e);
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ioe) {
                fsex.addSuppressed((Throwable)ioe);
            }
            throw fsex;
        }
    }

    public InputStream openDownloadStream(String fileName, String remotePath) throws FileSystemException {
        File localFile = this.getLocalFile(fileName, remotePath, true);
        if (!localFile.exists()) {
            throw new FileSystemException(String.format("File Not Found: [%s]", localFile.getAbsolutePath()));
        }
        try {
            return new FileInputStream(localFile);
        }
        catch (IOException | RuntimeException e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean delete(String fileName, String remotePath) throws FileSystemException {
        File localFile = this.getLocalFile(fileName, remotePath, true);
        if (localFile.exists()) {
            return localFile.delete();
        }
        return false;
    }

    public boolean deleteFolder(String remotePath) throws FileSystemException {
        String fullPath = this.getFullPath(remotePath);
        File directory = new File(fullPath);
        if (!directory.isDirectory()) {
            logger.error("Folder:{} delete failed, no such folder or path not a directory!", (Object)fullPath);
            return false;
        }
        try {
            FileUtils.deleteDirectory((File)directory);
            return true;
        }
        catch (IOException e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isFileExists(String fileName, String remotePath) {
        File localFile = this.getLocalFile(fileName, remotePath, true);
        return localFile.exists() && localFile.isFile();
    }

    public boolean isFolderExists(String remotePath) {
        String fullPath = this.getFullPath(remotePath);
        File directory = new File(fullPath);
        return directory.exists() && directory.isDirectory();
    }

    public FileInfo queryFileInfo(String fileName, String remotePath) {
        File localFile = this.getLocalFile(fileName, remotePath, true);
        return this.createFileInfo(localFile, fileName, remotePath);
    }

    private FileInfo createFileInfo(File localFile, String fileName, String remotePath) {
        LocalDiskFileInfo fileInfo = new LocalDiskFileInfo(this.fileClient);
        fileInfo.setFile(localFile);
        fileInfo.setFileName(fileName);
        fileInfo.setFilePath(remotePath);
        if (localFile.exists()) {
            fileInfo.setFileSize(localFile.length());
            fileInfo.setUploadDate(new Date(localFile.lastModified()));
            fileInfo.setExists(true);
        } else {
            fileInfo.setExists(false);
            fileInfo.setUploadDate(null);
        }
        return fileInfo;
    }

    public List<FileInfo> queryFiles(String remotePath) {
        String fullPath = this.getFullPath(remotePath);
        File directory = new File(fullPath);
        if (!directory.isDirectory()) {
            return Collections.emptyList();
        }
        File[] fileArray = directory.listFiles((FileFilter)FileFileFilter.FILE);
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>(fileArray.length);
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            fileInfoList.add(this.createFileInfo(file, file.getName(), remotePath));
        }
        return fileInfoList;
    }

    public List<String> querySubFolder(String remotePath) {
        String fullPath = this.getFullPath(remotePath);
        File directory = new File(fullPath);
        if (!directory.isDirectory()) {
            return Collections.emptyList();
        }
        File[] dirArray = directory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        ArrayList<String> dirList = new ArrayList<String>(dirArray.length);
        for (File dir : dirArray) {
            if (!dir.isDirectory()) continue;
            dirList.add(dir.getName());
        }
        return dirList;
    }

    public boolean move(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        File srcFile = this.getLocalFile(fileName, originPath, true);
        File targetFile = this.getLocalFile(targetFileName, targetPath, true);
        boolean result = this.move(srcFile, targetFile, isOverwrite);
        logger.info("File move success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{originPath, fileName, targetPath, targetFileName});
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean move(File srcFile, File targetFile, boolean isOverwrite) throws FileSystemException {
        if (!srcFile.exists()) {
            throw new FileSystemException(String.format("Source file:%s not found!", srcFile.getAbsolutePath()));
        }
        if (targetFile.exists()) {
            if (!isOverwrite) throw new FileSystemException(String.format("Source file:%s, copy to target file:%s failure! cause by: target file exist and over write is false!", srcFile.getAbsolutePath(), targetFile.getAbsolutePath()));
            if (targetFile.delete()) return srcFile.renameTo(targetFile);
            throw new FileSystemException(String.format("delete to target file:%s failure!", targetFile.getAbsolutePath()));
        }
        try {
            FileUtils.forceMkdirParent((File)targetFile);
            return srcFile.renameTo(targetFile);
        }
        catch (IOException e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean copy(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        File srcFile = this.getLocalFile(fileName, originPath, true);
        File targetFile = this.getLocalFile(targetFileName, targetPath, true);
        boolean result = this.copy(srcFile, targetFile, isOverwrite);
        logger.info("File copy success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{originPath, fileName, targetPath, targetFileName});
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean copy(File srcFile, File targetFile, boolean isOverwrite) throws FileSystemException {
        if (!srcFile.exists()) {
            throw new FileSystemException(String.format("Source file:%s not found!", srcFile.getAbsolutePath()));
        }
        if (targetFile.exists()) {
            if (!isOverwrite || !targetFile.delete()) throw new FileSystemException(String.format("Source file:%s, copy to target file:%s failure! cause by: target file exist and over write is false!", srcFile.getAbsolutePath(), targetFile.getAbsolutePath()));
            logger.debug("File:{} has delete!", (Object)targetFile.getAbsolutePath());
        } else {
            try {
                FileUtils.forceMkdirParent((File)targetFile);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage(), (Throwable)e);
            }
        }
        try (FileInputStream inStream = new FileInputStream(srcFile);
             FileOutputStream outStream = new FileOutputStream(targetFile);
             FileChannel in = inStream.getChannel();
             FileChannel out = outStream.getChannel();){
            in.transferTo(0L, in.size(), out);
            return true;
        }
        catch (Exception e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean available() {
        return true;
    }

    private File getLocalFile(String fileName, String filePath, boolean withBasePath) {
        String fullPath = filePath;
        if (withBasePath) {
            fullPath = this.getFullPath(filePath);
        }
        return new File(FilePathUtils.concatFileName((String)fullPath, (String)fileName));
    }

    private String getFullPath(String relativePath) {
        return FilePathUtils.concatRelativePath((String)this.fileClient.getHomePath(), (String)relativePath);
    }

    class LocalDiskOutputStream
    extends AbstractDefaultOutputStream {
        private File targetFile;
        private FileInfo targetFileInfo;

        public LocalDiskOutputStream(File targetFile, OutputStream outputStream, FileInfo targetFileInfo, long size) {
            super(outputStream, size);
            this.targetFile = targetFile;
            this.targetFileInfo = targetFileInfo;
        }

        protected void closeError(OutputStream innerStream) throws IOException {
            innerStream.close();
            if (this.targetFile.exists() && this.targetFile.delete()) {
                logger.debug("file:{} delete success!", (Object)this.targetFile.getAbsolutePath());
            }
            this.targetFileInfo.setFileSize(0L);
            this.targetFileInfo.setExists(false);
        }

        protected FileInfo closeSuccess(OutputStream innerStream) throws IOException {
            innerStream.close();
            this.targetFileInfo.setFileSize(this.getSendSize());
            this.targetFileInfo.setUploadDate(new Date());
            this.targetFileInfo.setExists(true);
            return this.targetFileInfo;
        }
    }
}

