DROP TABLE "FILE_FOLDER_INFO";
CREATE TABLE "FILE_FOLDER_INFO" (
"FOLDER_ID" NUMBER(25) NOT NULL ,
"FOLDER_PATH" VARCHAR2(128 BYTE) NULL ,
"PARENT_FOLDER_PATH" VARCHAR2(128 BYTE) NULL ,
"SERVER_ID" VARCHAR2(64 BYTE) NULL ,
"FOLDER_LEVEL" NUMBER NULL ,
"VERSION" NUMBER(32) NULL ,
"LEVEL2_FOLDER_PATH" VARCHAR2(128 BYTE) NULL ,
"LEVEL3_FOLDER_PATH" VARCHAR2(128 BYTE) NULL ,
"LEVEL4_FOLDER_PATH" VARCHAR2(128 BYTE) NULL ,
"LAST_UPDATE_TIME" DATE NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "FILE_FOLDER_INFO" IS 'FastDFS文件目录表';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."FOLDER_ID" IS '文件目录ID';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."FOLDER_PATH" IS '目录路径';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."PARENT_FOLDER_PATH" IS '父目录路径';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."SERVER_ID" IS '上传服务ID';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."FOLDER_LEVEL" IS '目录层级';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."VERSION" IS '版本号';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."LEVEL2_FOLDER_PATH" IS '二级目录';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."LEVEL3_FOLDER_PATH" IS '三级目录';
COMMENT ON COLUMN "FILE_FOLDER_INFO"."LEVEL4_FOLDER_PATH" IS '四级目录';

-- ----------------------------
-- Table structure for FILE_INFO
-- ----------------------------
DROP TABLE "FILE_INFO";
CREATE TABLE "FILE_INFO" (
"FILE_SEQ" NUMBER(25) NOT NULL ,
"FILE_NAME" VARCHAR2(256 BYTE) NULL ,
"FILE_PATH" VARCHAR2(256 BYTE) NULL ,
"EXT_NAME" VARCHAR2(32 BYTE) NULL ,
"FILE_ID" VARCHAR2(256 BYTE) NULL ,
"FILE_GROUP" VARCHAR2(64 BYTE) NULL ,
"SERVER_ID" VARCHAR2(64 BYTE) NULL ,
"FILE_SIZE" NUMBER(25) NULL ,
"UPLOAD_DATE" DATE NULL ,
"STATUS" NUMBER(1) NULL ,
"PS" VARCHAR2(512 BYTE) NULL ,
"FOLDER_ID" NUMBER(25) NULL 
)
LOGGING
NOCOMPRESS
NOCACHE

;
COMMENT ON TABLE "FILE_INFO" IS 'FastDFS文件信息表';
COMMENT ON COLUMN "FILE_INFO"."FILE_SEQ" IS '主键';
COMMENT ON COLUMN "FILE_INFO"."FILE_NAME" IS '远程文件文件名';
COMMENT ON COLUMN "FILE_INFO"."FILE_PATH" IS '远程虚拟文件存储路径';
COMMENT ON COLUMN "FILE_INFO"."EXT_NAME" IS '文件格式';
COMMENT ON COLUMN "FILE_INFO"."FILE_ID" IS '文件ID';
COMMENT ON COLUMN "FILE_INFO"."SERVER_ID" IS '上传服务ID';
COMMENT ON COLUMN "FILE_INFO"."FILE_SIZE" IS '文件大小（单位KB）';
COMMENT ON COLUMN "FILE_INFO"."UPLOAD_DATE" IS '上传时间';
COMMENT ON COLUMN "FILE_INFO"."STATUS" IS '状态（-1上传失败、0待上传、1 上传中、 2 已上传）';
COMMENT ON COLUMN "FILE_INFO"."PS" IS '附言';
COMMENT ON COLUMN "FILE_INFO"."FOLDER_ID" IS '文件所在目录ID';

-- ----------------------------
-- Indexes structure for table FILE_FOLDER_INFO
-- ----------------------------
CREATE INDEX "IDX_FILE_FOLDER_LEVEL"
ON "FILE_FOLDER_INFO" ("SERVER_ID" ASC, "LEVEL2_FOLDER_PATH" ASC, "LEVEL3_FOLDER_PATH" ASC, "LEVEL4_FOLDER_PATH" ASC)
LOGGING
VISIBLE;
CREATE INDEX "IDX_FILE_FOLDER_PARENT"
ON "FILE_FOLDER_INFO" ("SERVER_ID" ASC, "PARENT_FOLDER_PATH" ASC)
LOGGING
VISIBLE;
CREATE UNIQUE INDEX "IDX_FILE_FOLDER_PATH_FP"
ON "FILE_FOLDER_INFO" ("SERVER_ID" ASC, "FOLDER_PATH" ASC)
LOGGING
VISIBLE;

-- ----------------------------
-- Checks structure for table FILE_FOLDER_INFO
-- ----------------------------
ALTER TABLE "FILE_FOLDER_INFO" ADD CHECK ("FOLDER_ID" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table FILE_FOLDER_INFO
-- ----------------------------
ALTER TABLE "FILE_FOLDER_INFO" ADD PRIMARY KEY ("FOLDER_ID");

-- ----------------------------
-- Indexes structure for table FILE_INFO
-- ----------------------------
CREATE INDEX "IDX_FILE_INFO_FILE_FOLDER_ID"
ON "FILE_INFO" ("FOLDER_ID" ASC)
LOGGING
VISIBLE;
CREATE INDEX "IDX_FILE_INFO_FILE_ID"
ON "FILE_INFO" ("FILE_ID" ASC)
LOGGING
VISIBLE;
CREATE INDEX "IDX_FILE_INFO_FILE_PATH"
ON "FILE_INFO" ("FILE_PATH" ASC, "FILE_NAME" ASC)
LOGGING
VISIBLE;

-- ----------------------------
-- Checks structure for table FILE_INFO
-- ----------------------------
ALTER TABLE "FILE_INFO" ADD CHECK ("FILE_SEQ" IS NOT NULL);

-- ----------------------------
-- Primary Key structure for table FILE_INFO
-- ----------------------------
ALTER TABLE "FILE_INFO" ADD PRIMARY KEY ("FILE_SEQ");
