/*==============================================================*/
/* DBMS name:      MySQL 5.0                                    */
/* Created on:     2021/7/5 18:04:56                            */
/*==============================================================*/


/*==============================================================*/
/* Table: FILE_FOLDER_INFO                                      */
/*==============================================================*/
create table FILE_FOLDER_INFO
(
   FOLDER_ID            numeric(25,0) not null comment '文件目录ID',
   FOLDER_PATH          varchar(128) comment '目录路径',
   PARENT_FOLDER_PATH   varchar(128) comment '父目录路径',
   SERVER_ID            varchar(64) comment '上传服务ID',
   FOLDER_LEVEL         numeric(8,0) comment '目录层级',
   VERSION              numeric(32,0) comment '版本号',
   LEVEL2_FOLDER_PATH   varchar(128) comment '二级目录',
   LEVEL3_FOLDER_PATH   varchar(128) comment '三级目录',
   LEVEL4_FOLDER_PATH   varchar(128) comment '四级目录',
   LAST_UPDATE_TIME     datetime,
   primary key (FOLDER_ID),
   check ("FOLDER_ID" IS NOT NULL)
);

alter table FILE_FOLDER_INFO comment 'FastDFS文件目录表';

/*==============================================================*/
/* Index: IDX_FILE_FOLDER_LEVEL                                 */
/*==============================================================*/
create index IDX_FILE_FOLDER_LEVEL on FILE_FOLDER_INFO
(
   SERVER_ID,
   LEVEL2_FOLDER_PATH,
   LEVEL3_FOLDER_PATH,
   LEVEL4_FOLDER_PATH
);

/*==============================================================*/
/* Index: IDX_FILE_FOLDER_PARENT                                */
/*==============================================================*/
create index IDX_FILE_FOLDER_PARENT on FILE_FOLDER_INFO
(
   SERVER_ID,
   PARENT_FOLDER_PATH
);

/*==============================================================*/
/* Index: IDX_FILE_FOLDER_PATH_FP                               */
/*==============================================================*/
create unique index IDX_FILE_FOLDER_PATH_FP on FILE_FOLDER_INFO
(
   SERVER_ID,
   FOLDER_PATH
);

/*==============================================================*/
/* Table: FILE_INFO                                             */
/*==============================================================*/
create table FILE_INFO
(
   FILE_SEQ             numeric(25,0) not null comment '主键',
   FILE_NAME            varchar(256) comment '远程文件文件名',
   FILE_PATH            varchar(256) comment '远程虚拟文件存储路径',
   EXT_NAME             varchar(32) comment '文件格式',
   FILE_ID              varchar(256) comment '文件ID',
   FILE_GROUP           varchar(64),
   SERVER_ID            varchar(64) comment '上传服务ID',
   FILE_SIZE            numeric(25,0) comment '文件大小（单位KB）',
   UPLOAD_DATE          datetime comment '上传时间',
   STATUS               numeric(1,0) comment '状态（-1上传失败、0待上传、1 上传中、 2 已上传）',
   PS                   varchar(512) comment '附言',
   FOLDER_ID            numeric(25,0) comment '文件所在目录ID',
   primary key (FILE_SEQ),
   check ("FILE_SEQ" IS NOT NULL)
);

alter table FILE_INFO comment 'FastDFS文件信息表';

/*==============================================================*/
/* Index: IDX_FILE_INFO_FILE_FOLDER_ID                          */
/*==============================================================*/
create index IDX_FILE_INFO_FILE_FOLDER_ID on FILE_INFO
(
   FOLDER_ID
);

/*==============================================================*/
/* Index: IDX_FILE_INFO_FILE_ID                                 */
/*==============================================================*/
create index IDX_FILE_INFO_FILE_ID on FILE_INFO
(
   FILE_ID
);

/*==============================================================*/
/* Index: IDX_FILE_INFO_FILE_PATH                               */
/*==============================================================*/
create index IDX_FILE_INFO_FILE_PATH on FILE_INFO
(
   FILE_PATH,
   FILE_NAME
);

