/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.fastdfs;

import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.ProtoCommon;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerGroup;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageClientExt
extends StorageClient {
    private static final Logger logger = LoggerFactory.getLogger(StorageClientExt.class);
    public static final String RESULT_KEY_GROUP_NAME = "GROUP_NAME";
    public static final String RESULT_KEY_REMOTE_FILENAME = "REMOTE_FILENAME";
    public static final String RESULT_KEY_STATUS = "STATUS";
    public static final String RESULT_KEY_ERR_MSG = "ERR_MSG";
    public static final String RESULT_ERR_MSG_FDFS_SET_METADATA_ERROR = "FDFS_SET_METADATA_ERROR";
    public static final int COMM_RESULT_STATUS_SUCCESS = 0;
    public static final int COMM_RESULT_STATUS_ERROR = 9;
    public static final int FDFS_SET_METADATA_EROR = 5;
    public static final int FDFS_CLOSE_CONNECTOR_ERROR = 99;
    public static final int FDFS_UPLOAD_RESULT_ARRAY_LENGTH = 2;
    public static final int FDFS_STORAGE_SERVER_PORT = 23000;
    protected OutputStream fdfsOutput;
    protected InputStream fdfsInput;
    protected NameValuePair[] metaList;
    private Socket storageSocket;
    private boolean bNewConnection;
    private boolean sendDefaultMeta = false;

    public static synchronized void init(String trackerServer, int connectTimeout, int networkTimeout, int trackerHttpPort, String charset) throws IOException, MyException {
        String[] szTrackerServers;
        ClientGlobal.g_connect_timeout = connectTimeout;
        if (ClientGlobal.g_connect_timeout < 0) {
            ClientGlobal.g_connect_timeout = 5;
        }
        ClientGlobal.g_connect_timeout *= 1000;
        ClientGlobal.g_network_timeout = networkTimeout;
        if (ClientGlobal.g_network_timeout < 0) {
            ClientGlobal.g_network_timeout = 30;
        }
        ClientGlobal.g_network_timeout *= 1000;
        ClientGlobal.g_charset = charset;
        if (ClientGlobal.g_charset == null || ClientGlobal.g_charset.length() == 0) {
            ClientGlobal.g_charset = "ISO8859-1";
        }
        if ((szTrackerServers = trackerServer.split(",")) == null) {
            throw new MyException("item tracker_server in [" + trackerServer + "] not found");
        }
        InetSocketAddress[] trackerServers = new InetSocketAddress[szTrackerServers.length];
        for (int i = 0; i < szTrackerServers.length; ++i) {
            String[] parts = szTrackerServers[i].split("\\:", 2);
            if (parts.length != 2) {
                throw new MyException("the value of item \"tracker_server\" is invalid, the correct format is host:port");
            }
            trackerServers[i] = new InetSocketAddress(parts[0].trim(), Integer.parseInt(parts[1].trim()));
        }
        ClientGlobal.g_tracker_group = new TrackerGroup(trackerServers);
        ClientGlobal.g_tracker_http_port = trackerHttpPort;
        ClientGlobal.g_anti_steal_token = false;
    }

    public StorageClientExt() {
    }

    public StorageClientExt(TrackerServer trackerServer, StorageServer storageServer) {
        super(trackerServer, storageServer);
    }

    public Map<String, String> getMetaList() {
        HashMap<String, String> outMap = new HashMap<String, String>(16);
        if (this.metaList != null) {
            for (NameValuePair nvp : this.metaList) {
                outMap.put(nvp.getName(), nvp.getValue());
            }
        }
        return outMap;
    }

    public void setMetaList(Map<String, String> metaMap) {
        Set<Map.Entry<String, String>> entrySet = metaMap.entrySet();
        this.metaList = new NameValuePair[entrySet.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            this.metaList[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, String> getRemoteMetaData(String groupName, String remoteFilename) throws IOException, MyException {
        this.metaList = this.get_metadata(groupName, remoteFilename);
        return this.getMetaList();
    }

    public int initUpload(String fileName, long size, String path) {
        if (this.metaList == null && this.sendDefaultMeta) {
            this.metaList = new NameValuePair[]{new NameValuePair("PATH_AND_FILENAME", path)};
        }
        try {
            String fileExtName = StorageClientExt.getFileExtendName(fileName);
            this.bNewConnection = this.newWritableStorageConnection(null);
            this.storageSocket = this.storageServer.getSocket();
            byte[] wholePkg = this.getWholePkg(fileExtName, size);
            this.fdfsOutput = this.storageServer.getOutputStream();
            this.fdfsOutput.write(wholePkg);
            return 0;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.closeAll();
            return 9;
        }
    }

    public void sendBytes(byte[] bytes, int off, int len) throws IOException {
        this.fdfsOutput.write(bytes, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> finishUpload() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>(16);
        int intResult = 0;
        result.put(RESULT_KEY_STATUS, String.valueOf(intResult));
        try {
            ProtoCommon.RecvPackageInfo pkgInfo = ProtoCommon.recvPackage((InputStream)this.storageSocket.getInputStream(), (byte)100, (long)-1L);
            this.errno = pkgInfo.errno;
            if (pkgInfo.errno != 0) {
                result.put(RESULT_KEY_STATUS, String.valueOf(9));
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            if (pkgInfo.body.length <= 16) {
                result.put(RESULT_KEY_STATUS, String.valueOf(9));
                result.put(RESULT_KEY_ERR_MSG, "body length: " + pkgInfo.body.length + " <= " + 16);
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            String groupName = new String(pkgInfo.body, 0, 16).trim();
            String remoteFilename = new String(pkgInfo.body, 16, pkgInfo.body.length - 16);
            result.put(RESULT_KEY_GROUP_NAME, groupName);
            result.put(RESULT_KEY_REMOTE_FILENAME, remoteFilename);
            if (this.metaList == null) {
                HashMap<String, String> hashMap = result;
                return hashMap;
            }
            try {
                intResult = this.set_metadata(groupName, remoteFilename, this.metaList, (byte)79);
            }
            catch (Exception e) {
                intResult = 5;
                result.put(RESULT_KEY_STATUS, String.valueOf(intResult));
                result.put(RESULT_KEY_ERR_MSG, RESULT_ERR_MSG_FDFS_SET_METADATA_ERROR);
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (intResult != 0) {
                    this.errno = (byte)intResult;
                    try {
                        this.delete_file(groupName, remoteFilename);
                    }
                    catch (MyException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    result.put(RESULT_KEY_GROUP_NAME, null);
                    result.put(RESULT_KEY_REMOTE_FILENAME, null);
                }
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            this.closeAll();
        }
    }

    public int initDownload(FastDfsFileInfo fileInfo) {
        this.errno = 0;
        String groupName = fileInfo.getFileGroup();
        String remoteFilename = fileInfo.getFileId();
        try {
            this.bNewConnection = this.newReadableStorageConnection(groupName, remoteFilename);
            this.storageSocket = this.storageServer.getSocket();
            this.send_download_package(groupName, remoteFilename, 0L, 0L);
            this.fdfsInput = this.storageSocket.getInputStream();
            ProtoCommon.RecvHeaderInfo header = ProtoCommon.recvHeader((InputStream)this.fdfsInput, (byte)100, (long)-1L);
            this.errno = header.errno;
            if (header.errno != 0) {
                return header.errno;
            }
            fileInfo.setFileSize(header.body_len);
            return 0;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.closeAll();
            return 9;
        }
    }

    public int closeStorageServer() {
        IOException ioEx = null;
        try {
            block16: {
                block15: {
                    try {
                        if (this.fdfsInput != null) {
                            this.fdfsInput.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        ioEx = e;
                    }
                    try {
                        if (this.fdfsOutput != null) {
                            this.fdfsOutput.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (ioEx != null) break block15;
                        ioEx = e;
                    }
                }
                try {
                    if (this.bNewConnection && this.storageServer != null) {
                        this.storageServer.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (ioEx != null) break block16;
                    ioEx = e;
                }
            }
            if (ioEx == null) {
                int n = 0;
                return n;
            }
            int n = 9;
            return n;
        }
        finally {
            if (this.bNewConnection) {
                this.storageServer = null;
            }
            this.fdfsInput = null;
            this.fdfsOutput = null;
        }
    }

    public int closeServer() {
        IOException ioEx = null;
        try {
            block20: {
                block19: {
                    block18: {
                        try {
                            if (this.fdfsInput != null) {
                                this.fdfsInput.close();
                                this.fdfsInput = null;
                            }
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            ioEx = e;
                        }
                        try {
                            if (this.fdfsOutput != null) {
                                this.fdfsOutput.close();
                                this.fdfsOutput = null;
                            }
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            if (ioEx != null) break block18;
                            ioEx = e;
                        }
                    }
                    try {
                        if (this.bNewConnection && this.storageServer != null && this.storageServer.getSocket() != null && !this.storageServer.getSocket().isClosed()) {
                            this.storageServer.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (ioEx != null) break block19;
                        ioEx = e;
                    }
                }
                try {
                    if (this.trackerServer != null && this.trackerServer.getSocket() != null && !this.trackerServer.getSocket().isClosed()) {
                        this.trackerServer.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (ioEx != null) break block20;
                    ioEx = e;
                }
            }
            if (ioEx == null) {
                int n = 0;
                return n;
            }
            int n = 9;
            return n;
        }
        finally {
            if (this.bNewConnection) {
                this.storageServer = null;
            }
            this.fdfsInput = null;
            this.fdfsOutput = null;
        }
    }

    public int closeAll() {
        IOException ioEx = null;
        try {
            block19: {
                block18: {
                    block17: {
                        try {
                            if (this.fdfsInput != null) {
                                this.fdfsInput.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            ioEx = e;
                        }
                        try {
                            if (this.fdfsOutput != null) {
                                this.fdfsOutput.close();
                            }
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            if (ioEx != null) break block17;
                            ioEx = e;
                        }
                    }
                    try {
                        if (this.storageServer != null) {
                            this.storageSocket.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (ioEx != null) break block18;
                        ioEx = e;
                    }
                }
                try {
                    if (this.trackerServer != null) {
                        this.trackerServer.close();
                    }
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    if (ioEx != null) break block19;
                    ioEx = e;
                }
            }
            if (ioEx == null) {
                int n = 0;
                return n;
            }
            int n = 9;
            return n;
        }
        finally {
            this.storageServer = null;
            this.fdfsInput = null;
            this.fdfsOutput = null;
        }
    }

    public static String getFileExtendName(String fileName) {
        int nPos = fileName.lastIndexOf(46);
        if (nPos > 0 && fileName.length() - nPos <= 7) {
            return fileName.substring(nPos + 1);
        }
        return "";
    }

    public String checkPath(String filePath) {
        return filePath.replaceAll("\\\\", "/").replaceAll("/+", "/");
    }

    private byte[] getFdfsExtNameBytes(String fileExtName) throws UnsupportedEncodingException {
        byte[] extNameBs = new byte[6];
        Arrays.fill(extNameBs, (byte)0);
        if (fileExtName != null && !fileExtName.isEmpty()) {
            byte[] bs = fileExtName.getBytes(ClientGlobal.g_charset);
            int extNameLen = bs.length;
            if (extNameLen > 6) {
                extNameLen = 6;
            }
            System.arraycopy(bs, 0, extNameBs, 0, extNameLen);
        }
        return extNameBs;
    }

    private byte[] getWholePkg(String fileExtName, long fileSize) throws UnsupportedEncodingException {
        byte[] extNameBs = this.getFdfsExtNameBytes(fileExtName);
        byte[] sizeBytes = new byte[9];
        long bodyLen = (long)(sizeBytes.length + 6) + fileSize;
        sizeBytes[0] = (byte)this.storageServer.getStorePathIndex();
        int offset = 1;
        byte[] hexLenBytes = ProtoCommon.long2buff((long)fileSize);
        System.arraycopy(hexLenBytes, 0, sizeBytes, offset, hexLenBytes.length);
        byte[] header = ProtoCommon.packHeader((byte)11, (long)bodyLen, (byte)0);
        byte[] wholePkg = new byte[(int)((long)header.length + bodyLen - fileSize)];
        System.arraycopy(header, 0, wholePkg, 0, header.length);
        System.arraycopy(sizeBytes, 0, wholePkg, header.length, sizeBytes.length);
        offset = header.length + sizeBytes.length;
        System.arraycopy(extNameBs, 0, wholePkg, offset, extNameBs.length);
        offset += extNameBs.length;
        return wholePkg;
    }

    public boolean isSendDefaultMeta() {
        return this.sendDefaultMeta;
    }

    public void setSendDefaultMeta(boolean sendDefaultMeta) {
        this.sendDefaultMeta = sendDefaultMeta;
    }

    public OutputStream getOutputStream() {
        return this.fdfsOutput;
    }

    public InputStream getInputStream() {
        return this.fdfsInput;
    }

    public TrackerServer getTrackerServer() {
        return this.trackerServer;
    }

    public StorageServer getStorageServer() {
        return this.storageServer;
    }
}

