/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.fastdfs;

import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.client.AbstractFileClient;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsConfig;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileClientCommand;
import cn.com.yusys.yusp.commons.file.client.fastdfs.StorageClientExt;
import cn.com.yusys.yusp.commons.file.client.fastdfs.service.FastDfsCommandService;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class FastDfsFileClient
extends AbstractFileClient<FastDfsConfig> {
    public static final String FAST_DFS_FILE_SYSTEM_TYPE = "FASTDFS";
    private final FastDfsCommandService fastDfsCommandService;

    public FastDfsFileClient(String clientId, FastDfsConfig connector, GenericObjectPoolConfig<FileClientCommand> poolConfig, FastDfsCommandService fastDfsCommandService) {
        super(clientId, (ConnectConfig)connector, poolConfig);
        this.fastDfsCommandService = fastDfsCommandService;
    }

    public FileClientCommand createCommand(FastDfsConfig fastdfsConfig) {
        return new FastDfsFileClientCommand(this, this.fastDfsCommandService, this.getHomePath());
    }

    public String getFileSystemType() {
        return FAST_DFS_FILE_SYSTEM_TYPE;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        FastDfsConfig fastdfsConfig = (FastDfsConfig)this.getConnectConfig();
        StorageClientExt.init(fastdfsConfig.getTrackerServers(), fastdfsConfig.getConnectTimeout(), fastdfsConfig.getNetworkTimeout(), fastdfsConfig.getTrackerHttpPort(), fastdfsConfig.getCharset());
    }
}

