/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.file.client.fastdfs;

import cn.com.yusys.yusp.commons.file.AbstractUploadStream;
import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.FileClientCommand;
import cn.com.yusys.yusp.commons.file.FileInfo;
import cn.com.yusys.yusp.commons.file.FileSystemException;
import cn.com.yusys.yusp.commons.file.client.AbstractDefaultOutputStream;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileClient;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFileInfo;
import cn.com.yusys.yusp.commons.file.client.fastdfs.FastDfsFolderInfo;
import cn.com.yusys.yusp.commons.file.client.fastdfs.StorageClientExt;
import cn.com.yusys.yusp.commons.file.client.fastdfs.service.FastDfsCommandService;
import cn.com.yusys.yusp.commons.file.util.FilePathUtils;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.IdUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.csource.common.MyException;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FastDfsFileClientCommand
implements FileClientCommand {
    private static final Logger logger = LoggerFactory.getLogger(FastDfsFileClientCommand.class);
    private final String serverId;
    private final String rootPath;
    private final FastDfsFileClient dfsFileServer;
    private final FastDfsCommandService fastDfsCommandService;
    private boolean optimisticLockEnabled = false;
    private StorageClientExt storageClientExt = null;

    public FastDfsFileClientCommand(FastDfsFileClient dfsFileServer, FastDfsCommandService fastDfsCommandService, String rootPath) {
        this.rootPath = rootPath;
        this.dfsFileServer = dfsFileServer;
        this.fastDfsCommandService = fastDfsCommandService;
        this.serverId = this.dfsFileServer.getClientId();
    }

    public boolean isOptimisticLockEnabled() {
        return this.optimisticLockEnabled;
    }

    public void setOptimisticLockEnabled(boolean optimisticLockEnabled) {
        this.optimisticLockEnabled = optimisticLockEnabled;
    }

    public FileInfo upload(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        try {
            File file = new File(this.concatFileName(localPath, localFileName));
            Asserts.isTrue((boolean)file.exists(), (Object[])new Object[]{"file:%s must exists!", file.getAbsolutePath()});
            FastDfsFileInfo fastDfsFileInfo = this.isFileExists(remoteFileName, remotePath) ? this.uploadWithOverwrite(file, remoteFileName, remotePath) : this.upload(file, remoteFileName, remotePath);
            return this.convertToFileInfo(fastDfsFileInfo);
        }
        catch (FileSystemException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FileSystemException(String.format("upload failed: localFile:%s,%s, remoteFile: %s,%s: %s", localFileName, localPath, remoteFileName, remotePath, e.getMessage()), (Throwable)e);
        }
    }

    private FastDfsFileInfo upload(File localFile, String remoteFileName, String remotePath) {
        FastDfsFileInfo info = new FastDfsFileInfo();
        info.setFileName(remoteFileName);
        info.setFilePath(this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
        info.setFileSize(localFile.length());
        String extName = StorageClientExt.getFileExtendName(localFile.getName());
        StorageClientExt workStorageClientExt = this.getClient();
        try {
            String[] strResult = workStorageClientExt.upload_file(localFile.getPath(), extName, null);
            if (strResult == null || strResult.length < 2) {
                info.setStatus(-1);
                info.setPs("FastDFS File Upload Return Invalid." + strResult);
                String result = strResult == null ? "" : Arrays.asList(strResult).toString();
                logger.error("FastDFS File Upload failed, {},{},{}, localFile: {}, result: {}", new Object[]{this.serverId, remoteFileName, remotePath, localFile.getAbsolutePath(), result});
                throw new FileSystemException(String.format("upload failed: %s, %s, localFile: %s, result: %s", remoteFileName, remotePath, localFile.getAbsolutePath(), result));
            }
            info.setFileGroup(strResult[0]);
            info.setFileId(strResult[1]);
            info.setFileSeq(IdUtils.nextId());
            info.setExtName(extName);
            info.setUploadDate(new Date());
            info.setStatus(2);
            info.setServerId(this.serverId);
            if (info.getStatus() == 2) {
                this.checkInfoToDBAndDeleteDfsFileWhenFailed(info, workStorageClientExt);
            }
        }
        catch (FileSystemException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FileSystemException(String.format("FastDfs Error, serverId: %s, path: %s,%s,%s, Msg: %s", this.serverId, localFile.getAbsolutePath(), remoteFileName, remotePath, e.getMessage()), (Throwable)e);
        }
        return info;
    }

    private FastDfsFileInfo uploadWithOverwrite(File localFile, String remoteFileName, String remotePath) {
        FastDfsFileInfo info;
        block6: {
            FastDfsFileInfo targetFileInfo = this.queryDfsFileInfo(remoteFileName, remotePath);
            info = new FastDfsFileInfo();
            info.setFileName(remoteFileName);
            info.setFilePath(this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
            info.setFileSize(localFile.length());
            String extName = StorageClientExt.getFileExtendName(localFile.getName());
            info.setExtName(extName);
            StorageClientExt workStorageClientExt = this.getClient();
            String oldGroupId = targetFileInfo.getFileGroup();
            String oldFileId = targetFileInfo.getFileId();
            try {
                String[] strResult = workStorageClientExt.upload_file(localFile.getPath(), extName, null);
                if (strResult == null || strResult.length < 2) {
                    info.setStatus(-1);
                    info.setPs("FastDFS File Upload Return Invalid." + strResult);
                    String result = strResult == null ? "" : Arrays.asList(strResult).toString();
                    logger.error("FastDFS File Upload failed, {},{},{}, localFile: {}, result: {}", new Object[]{this.serverId, remoteFileName, remotePath, localFile.getAbsolutePath(), result});
                    throw new FileSystemException(String.format("upload failed: %s, %s, localFile: %s, result: %s", remoteFileName, remotePath, localFile.getAbsolutePath(), result));
                }
                info.setFileGroup(strResult[0]);
                info.setFileId(strResult[1]);
                info.setUploadDate(new Date());
                info.setStatus(2);
                info.setServerId(this.serverId);
                info.setFolderId(targetFileInfo.getFolderId());
                info.setFileSeq(targetFileInfo.getFileSeq());
                boolean updateResult = this.fastDfsCommandService.updateFileInfo(info);
                if (updateResult) {
                    int deleteResult = workStorageClientExt.delete_file(oldGroupId, oldFileId);
                    if (deleteResult != 0) {
                        logger.error("FastDFS delete old file failed when upload file. GroupId: {}, FileId: {}.", (Object)oldGroupId, (Object)oldFileId);
                    }
                    break block6;
                }
                logger.error("FastDFS delete old file failed after upload file to update db.");
                throw new FileSystemException(String.format("upload failed: %s, %s, localFile: %s, result: %s", remoteFileName, remotePath, localFile.getAbsolutePath(), false));
            }
            catch (FileSystemException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FileSystemException(String.format("FastDfs Error, serverId: %s, path: %s,%s,%s, Msg: %s", this.serverId, localFile.getAbsolutePath(), remoteFileName, remotePath, e.getMessage()), (Throwable)e);
            }
        }
        return info;
    }

    private void checkInfoToDBAndDeleteDfsFileWhenFailed(FastDfsFileInfo info, StorageClientExt workStorageClientExt) throws IOException, MyException {
        try {
            this.fastDfsCommandService.checkFolderAndFileInfoToDB(this.serverId, this.rootPath, info);
        }
        catch (Exception ex) {
            logger.error("checkInfoToDBAndDeleteDfsFileWhenFailed failed: {},{}", new Object[]{this.serverId, this.rootPath, ex});
            int deleteResult = workStorageClientExt.delete_file(info.getFileGroup(), info.getFileId());
            String errorMessage = deleteResult == 0 ? String.format("folder create error: %s,%s, file: %s,%s", this.serverId, info.getFilePath(), info.getFileGroup(), info.getFileId()) : String.format("folder create error: %s,%s, delete file error ret:%d file: %s,%s", this.serverId, info.getFilePath(), deleteResult, info.getFileGroup(), info.getFileId());
            logger.error(errorMessage, (Throwable)ex);
            throw new FileSystemException(errorMessage, (Throwable)ex);
        }
    }

    public AbstractUploadStream openUploadStream(String remoteFileName, String remotePath, long fileSize) throws FileSystemException {
        StorageClientExt workStorageClientExt = this.getClient();
        try {
            workStorageClientExt.initUpload(remoteFileName, fileSize, remotePath);
            FastDfsFileInfo fastDfsFileInfo = new FastDfsFileInfo();
            fastDfsFileInfo.setFileName(remoteFileName);
            fastDfsFileInfo.setFilePath(this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
            fastDfsFileInfo.setExtName(StorageClientExt.getFileExtendName(remoteFileName));
            fastDfsFileInfo.setFileSize(fileSize);
            fastDfsFileInfo.setServerId(this.serverId);
            fastDfsFileInfo.setStatus(1);
            FileInfo fileInfo = this.convertToFileInfo(fastDfsFileInfo);
            return new FastDfsDefaultOutputStream(new FastDfsOutputStream(fastDfsFileInfo, workStorageClientExt), fileSize, fileInfo);
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public boolean delete(String remoteFileName, String remotePath) throws FileSystemException {
        List<FastDfsFileInfo> infoList = this.fastDfsCommandService.queryFileInfo(this.serverId, remoteFileName, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
        if (infoList != null && !infoList.isEmpty()) {
            for (FastDfsFileInfo info : infoList) {
                if (this.delete(info)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean delete(FastDfsFileInfo info) {
        if (info == null || info.getFileId() == null) {
            logger.error("delete file failed, serverId: {}, info is null", (Object)this.serverId);
            return false;
        }
        StorageClientExt workStorageClientExt = this.getClient();
        try {
            List<FastDfsFileInfo> resultList = this.fastDfsCommandService.queryFileInfosByIdAndGroup(info.getFileId(), info.getFileGroup());
            if (resultList.size() > 1) {
                this.fastDfsCommandService.deleteFileInfo(info);
                return true;
            }
            this.fastDfsCommandService.deleteFileInfo(info);
            if (workStorageClientExt.delete_file(info.getFileGroup(), info.getFileId()) == 0) {
                return true;
            }
            if (workStorageClientExt.query_file_info(info.getFileGroup(), info.getFileId()) == null) {
                return true;
            }
            logger.error("FastDfs Error Msg: \u670d\u52a1\u5668\u6e05\u9664\u6587\u4ef6 group [{}] fileId[{}] \u5931\u8d25!", (Object)info.getFileGroup(), (Object)info.getFileId());
            return false;
        }
        catch (Exception e) {
            logger.error(String.format("delete file failed, serverId: %s, %s,%s: %s", this.serverId, info.getFileGroup(), info.getFileId(), e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public boolean isFileExists(String remoteFileName, String remotePath) {
        List<FastDfsFileInfo> list = this.fastDfsCommandService.queryFileInfo(this.serverId, remoteFileName, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
        return CollectionUtils.nonEmpty(list);
    }

    public FileInfo queryFileInfo(String remoteFileName, String remotePath) {
        FastDfsFileInfo info = this.queryDfsFileInfo(remoteFileName, remotePath);
        return Optional.ofNullable(this.convertToFileInfo(info)).orElseGet(() -> this.getNonExistsFileInfo(remotePath, remoteFileName));
    }

    public FastDfsFileInfo queryDfsFileInfo(String fileName, String remotePath) {
        List<FastDfsFileInfo> list = this.fastDfsCommandService.queryFileInfo(this.serverId, fileName, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
        return CollectionUtils.nonEmpty(list) ? list.get(0) : null;
    }

    public List<FileInfo> queryFiles(String remotePath) {
        List<FastDfsFileInfo> listFastDfs = this.fastDfsCommandService.queryFileInfosInFolder(this.serverId, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath), null);
        return Optional.ofNullable(listFastDfs).orElse(Collections.emptyList()).stream().map(this::convertToFileInfo).collect(Collectors.toList());
    }

    private void copyAndMove(String originFileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite, Consumer<FastDfsFileInfo> operate) {
        FastDfsFileInfo fastDfsInfo = this.queryDfsFileInfo(originFileName, originPath);
        if (fastDfsInfo == null) {
            throw new FileSystemException(String.format("Source file:%s not found!", FilePathUtils.getAbsolutePath((String)originPath, (String)originFileName)));
        }
        FastDfsFileInfo targetInfo = this.queryDfsFileInfo(targetFileName, targetPath);
        if (targetInfo != null) {
            if (!isOverwrite) {
                throw new FileSystemException(String.format("Source file:%s, copy to target file:%s failure! cause by: target file exist and over write is false!", FilePathUtils.getAbsolutePath((String)originPath, (String)originFileName), FilePathUtils.getAbsolutePath((String)targetPath, (String)targetFileName)));
            }
            if (!this.delete(targetFileName, targetPath)) {
                throw new FileSystemException(String.format("delete to target file:%s failure!", FilePathUtils.getAbsolutePath((String)targetPath, (String)targetFileName)));
            }
        }
        operate.accept(fastDfsInfo);
    }

    public boolean move(String originFileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        this.copyAndMove(originFileName, originPath, targetFileName, targetPath, isOverwrite, fastDfsFileInfo -> this.fastDfsCommandService.checkFolderAndMoveFileInDB(this.serverId, this.rootPath, targetFileName, targetPath, (FastDfsFileInfo)fastDfsFileInfo));
        logger.info("File move success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{originPath, originFileName, targetPath, targetFileName});
        return true;
    }

    public boolean copy(String fileName, String originPath, String targetFileName, String targetPath, boolean isOverwrite) throws FileSystemException {
        this.copyAndMove(fileName, originPath, targetFileName, targetPath, isOverwrite, fastDfsFileInfo -> this.fastDfsCommandService.checkFolderAndCopyFileInDB(this.serverId, this.rootPath, targetFileName, targetPath, (FastDfsFileInfo)fastDfsFileInfo));
        logger.info("File copy success! source file path:{}, source file name:{} --> target file path:{}, target file name:{}", new Object[]{originPath, fileName, targetPath, targetFileName});
        return true;
    }

    public InputStream openDownloadStream(String remoteFileName, String remotePath) throws FileSystemException {
        StorageClientExt workStorageClientExt = this.getClient();
        try {
            FastDfsFileInfo info = null;
            List<FastDfsFileInfo> list = this.fastDfsCommandService.queryFileInfo(this.serverId, remoteFileName, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
            if (!CollectionUtils.nonEmpty(list)) {
                throw new FileSystemException("File Not Found: [" + this.concatFileName(this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath), remoteFileName) + "]");
            }
            info = list.get(0);
            int status = workStorageClientExt.initDownload(info);
            if (status != 0) {
                workStorageClientExt = this.reloadStorageServer(info, workStorageClientExt);
                status = workStorageClientExt.initDownload(info);
            }
            if (status != 0) {
                throw new FileSystemException("Download Initialzation Failure !");
            }
            return new FastDfsInputStream(workStorageClientExt, info.getFileSize());
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public boolean download(String localFileName, String localPath, String remoteFileName, String remotePath) throws FileSystemException {
        try {
            FastDfsFileInfo info = null;
            List<FastDfsFileInfo> list = this.fastDfsCommandService.queryFileInfo(this.serverId, remoteFileName, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
            if (list != null && !list.isEmpty()) {
                info = list.get(0);
            }
            if (info == null) {
                throw new FileSystemException(String.format("Files to download:%s not found!", FilePathUtils.getAbsolutePath((String)remotePath, (String)remoteFileName)));
            }
            info.setFileName(localFileName);
            return this.download(info, localPath);
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean download(FastDfsFileInfo info, String localPath) {
        try {
            FileUtils.forceMkdirParent((File)new File(StringUtils.builder0((Object[])new Object[]{localPath, File.separator, info.getFileName()})));
        }
        catch (IOException e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
        StorageClientExt workStorageClientExt = this.getClient();
        try {
            int status = workStorageClientExt.download_file(info.getFileGroup(), info.getFileId(), this.concatFileName(localPath, info.getFileName()));
            if (status != 0) {
                StorageClientExt originStorageClientExt = this.reloadStorageServer(info, workStorageClientExt);
                status = originStorageClientExt.download_file(info.getFileGroup(), info.getFileId(), this.concatFileName(localPath, info.getFileName()));
                if (originStorageClientExt.getStorageServer() != null) {
                    originStorageClientExt.getStorageServer().close();
                }
            }
            return status == 0;
        }
        catch (Exception e) {
            throw new FileSystemException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean deleteFolder(String remotePath) throws FileSystemException {
        if (StringUtils.isBlank((CharSequence)remotePath) || StringUtils.equals((CharSequence)"/", (CharSequence)remotePath)) {
            logger.error("delete folder {},{},{} failed, cannot delete root folder", new Object[]{this.serverId, remotePath, remotePath});
            return false;
        }
        String fullPath = this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath);
        FastDfsFolderInfo fastDfsFolderInfo = this.fastDfsCommandService.queryFolderByPath(this.serverId, fullPath);
        if (fastDfsFolderInfo == null) {
            logger.error("Folder:{} delete failed, no such folder", (Object)fullPath);
            return false;
        }
        boolean result = this.deleteFolderBottomUp(fastDfsFolderInfo);
        String parentPath = this.getParentFolderPath(remotePath);
        String fullParentPath = this.fastDfsCommandService.concatRelativePath(this.rootPath, parentPath);
        this.fastDfsCommandService.addFolderVersion(this.serverId, this.rootPath, fullParentPath, new Date());
        return result;
    }

    public boolean deleteFolderBottomUp(FastDfsFolderInfo fastDfsFolderInfo) {
        List<FastDfsFileInfo> listFastDfs;
        List<FastDfsFolderInfo> folderInfoList = this.fastDfsCommandService.querySubFolderInfos(this.serverId, fastDfsFolderInfo.getFolderPath());
        if (folderInfoList != null) {
            for (FastDfsFolderInfo fastDfsFolderInfo2 : folderInfoList) {
                if (this.deleteFolderBottomUp(fastDfsFolderInfo2)) continue;
                logger.error("deleteFolder {} failed, delete subFolder error: {}", (Object)fastDfsFolderInfo.getFolderPath(), (Object)fastDfsFolderInfo2.getFolderPath());
                return false;
            }
        }
        if ((listFastDfs = this.fastDfsCommandService.queryFilesByFolderId(this.serverId, fastDfsFolderInfo.getFolderId())) != null) {
            for (FastDfsFileInfo dfs : listFastDfs) {
                if (this.delete(dfs)) continue;
                logger.error("deleteFolder {} failed, delete file error: {},{}", new Object[]{fastDfsFolderInfo.getFolderPath(), dfs.getFileName(), dfs.getFilePath()});
                return false;
            }
        }
        this.fastDfsCommandService.deleteFolderPathCache(this.serverId, this.rootPath, fastDfsFolderInfo.getFolderPath());
        long l = fastDfsFolderInfo.getFolderId();
        Integer version = null;
        if (this.optimisticLockEnabled) {
            version = fastDfsFolderInfo.getVersion();
        }
        return this.fastDfsCommandService.deleteFileFolderInfoWithVersion(this.serverId, l, version);
    }

    public boolean isFolderExists(String remotePath) {
        return this.fastDfsCommandService.isFolderExists(this.serverId, this.rootPath, remotePath);
    }

    public List<String> querySubFolder(String remotePath) {
        List<FastDfsFolderInfo> folderInfos = this.fastDfsCommandService.querySubFolderInfos(this.serverId, this.fastDfsCommandService.concatRelativePath(this.rootPath, remotePath));
        if (folderInfos != null) {
            return folderInfos.stream().map(folderInfo -> StringUtils.substringAfterLast((String)folderInfo.getFolderPath(), (String)"/")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean available() {
        return true;
    }

    public void close() {
        if (this.storageClientExt != null) {
            this.storageClientExt.closeAll();
            this.storageClientExt = null;
        }
    }

    private StorageClientExt reloadStorageServer(FastDfsFileInfo info, StorageClientExt oldStorageClientExt) throws IOException, MyException {
        StorageServer[] storageServerArray;
        oldStorageClientExt.closeServer();
        org.csource.fastdfs.FileInfo csFileInfo = oldStorageClientExt.get_file_info(info.getFileGroup(), info.getFileId());
        int diskPathIndex = Integer.parseInt(info.getFileId().substring(1, 3));
        StorageServer newStorageServer = null;
        TrackerClient tracker = new TrackerClient();
        for (StorageServer server : storageServerArray = tracker.getStoreStorages(oldStorageClientExt.getTrackerServer(), info.getFileGroup())) {
            String ipAddr = server.getInetSocketAddress().getAddress().toString().substring(1);
            if (csFileInfo.getSourceIpAddr().equals(ipAddr) && diskPathIndex == server.getStorePathIndex()) {
                newStorageServer = server;
                continue;
            }
            server.close();
        }
        StorageClientExt newStorageClientExt = new StorageClientExt(oldStorageClientExt.getTrackerServer(), newStorageServer);
        logger.info("reload StorageServer [{}]: serverIp[{}], fileGroup[{}], fileId[{}]", new Object[]{"Success", csFileInfo.getSourceIpAddr(), info.getFileGroup(), info.getFileId()});
        return newStorageClientExt;
    }

    public StorageClientExt getClient() {
        return this.getClient(true);
    }

    public StorageClientExt getClient(boolean createWhenNull) {
        if (this.storageClientExt != null) {
            return this.storageClientExt;
        }
        if (!createWhenNull) {
            return null;
        }
        FastDfsFileClientCommand fastDfsFileClientCommand = this;
        synchronized (fastDfsFileClientCommand) {
            if (this.storageClientExt != null) {
                return this.storageClientExt;
            }
            try {
                TrackerClient trackerClient = new TrackerClient();
                TrackerServer trackerServer = trackerClient.getConnection();
                StorageServer storageServer = null;
                this.storageClientExt = new StorageClientExt(trackerServer, storageServer);
                return this.storageClientExt;
            }
            catch (Exception e) {
                throw new FileSystemException(String.format("getClient error: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    public FileInfo convertToFileInfo(FastDfsFileInfo dfsInfo) {
        if (dfsInfo == null) {
            logger.warn("dfsInfo is null when try to du convert to file info");
            return null;
        }
        FileInfo info = new FileInfo((FileClient)this.dfsFileServer);
        String relativePath = dfsInfo.getFilePath();
        relativePath = relativePath.length() <= this.rootPath.length() ? "" : relativePath.substring(this.rootPath.length());
        info.setFileName(dfsInfo.getFileName());
        info.setFilePath(relativePath);
        info.setFileSize(dfsInfo.getFileSize());
        info.setUploadDate(dfsInfo.getUploadDate());
        if (dfsInfo.getStatus() == 2) {
            info.setExists(true);
        } else {
            info.setExists(false);
        }
        return info;
    }

    public FileInfo getNonExistsFileInfo(String remotePath, String remoteFile) {
        FileInfo info = new FileInfo((FileClient)this.dfsFileServer);
        info.setFileSize(0L);
        info.setFileName(remoteFile);
        info.setFilePath(remotePath);
        info.setFileSize(0L);
        info.setExists(false);
        return info;
    }

    private String concatFileName(String path, String fileName) {
        return FilePathUtils.concatFileName((String)path, (String)fileName);
    }

    public String getParentFolderPath(String remotePath) {
        String filePath = null;
        int lastIdx = remotePath.lastIndexOf("/");
        filePath = lastIdx > 0 ? remotePath.substring(0, lastIdx) : null;
        return filePath;
    }

    private class FastDfsInputStream
    extends InputStream {
        private StorageClientExt storageClientExt;
        private long remainBytes;
        private long markedRemainBytes;
        private InputStream innerStream;

        public FastDfsInputStream(StorageClientExt storageClientExt, long fileSize) {
            this.storageClientExt = storageClientExt;
            this.innerStream = this.storageClientExt.getInputStream();
            this.remainBytes = fileSize;
        }

        @Override
        public int read() throws IOException {
            if (this.remainBytes > 0L) {
                --this.remainBytes;
                return this.innerStream.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytes = -1;
            if (this.remainBytes > 0L && (bytes = this.innerStream.read(b, off, this.remainBytes > (long)b.length ? b.length : (int)this.remainBytes)) > 0) {
                this.remainBytes -= (long)bytes;
            }
            return bytes;
        }

        @Override
        public long skip(long n) throws IOException {
            long actualSkipped = this.innerStream.skip(n);
            if (actualSkipped > 0L) {
                this.remainBytes -= actualSkipped;
            }
            return actualSkipped;
        }

        @Override
        public int available() {
            return (int)this.remainBytes;
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.storageClientExt != null) {
                    this.storageClientExt.closeServer();
                }
                if (this.storageClientExt != null && this.storageClientExt.getStorageServer() != null) {
                    this.storageClientExt.getStorageServer().close();
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public synchronized void mark(int readLimit) {
            if (this.markedRemainBytes != -1L) {
                throw new IllegalStateException("already makered, must reset first");
            }
            this.innerStream.mark(readLimit);
            this.markedRemainBytes = this.remainBytes;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.markedRemainBytes == -1L) {
                throw new IllegalStateException("no valid mark currently, call mark first");
            }
            this.innerStream.reset();
            this.remainBytes = this.markedRemainBytes;
            this.markedRemainBytes = -1L;
        }
    }

    public class FastDfsDefaultOutputStream
    extends AbstractDefaultOutputStream {
        private FileInfo fileInfo;

        public FastDfsDefaultOutputStream(OutputStream outputStream, long size, FileInfo fileInfo) {
            super(outputStream, size);
            this.fileInfo = fileInfo;
        }

        protected void closeError(OutputStream innerStream) throws IOException {
            innerStream.close();
        }

        protected FileInfo closeSuccess(OutputStream innerStream) throws IOException {
            innerStream.close();
            return FastDfsFileClientCommand.this.queryFileInfo(this.fileInfo.getFileName(), this.fileInfo.getFilePath());
        }
    }

    private class FastDfsOutputStream
    extends OutputStream {
        private StorageClientExt storageClientExt;
        private FastDfsFileInfo info;
        private long remainSize;
        private OutputStream innerStream;

        public FastDfsOutputStream(FastDfsFileInfo info, StorageClientExt storageClientExt) {
            this.storageClientExt = storageClientExt;
            this.info = info;
            this.remainSize = info.getFileSize();
            this.innerStream = this.storageClientExt.getOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            if (this.remainSize >= 1L) {
                this.innerStream.write(b);
                --this.remainSize;
            } else {
                this.closeOverLimitError();
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.remainSize >= (long)len) {
                this.innerStream.write(b, off, len);
                this.remainSize -= (long)len;
            } else {
                this.closeOverLimitError();
            }
        }

        @Override
        public void flush() throws IOException {
            this.innerStream.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.remainSize > 0L) {
                    this.storageClientExt.closeAll();
                    return;
                }
                Map<String, String> out = this.storageClientExt.finishUpload();
                String groupName = out.get("GROUP_NAME");
                String remoteFilename = out.get("REMOTE_FILENAME");
                if (groupName == null || remoteFilename == null) {
                    throw new IOException("FastDfs Error Mgs: FastdfsOutputStream close error !");
                }
                this.info.setFileGroup(groupName);
                this.info.setFileId(remoteFilename);
                this.info.setFileSeq(IdUtils.nextId());
                this.info.setUploadDate(new Date());
                this.info.setStatus(2);
                this.callCheckFolderAndFileInfoToDB();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void callCheckFolderAndFileInfoToDB() throws IOException, MyException {
            try {
                FastDfsFileClientCommand.this.fastDfsCommandService.checkFolderAndFileInfoToDB(FastDfsFileClientCommand.this.serverId, FastDfsFileClientCommand.this.rootPath, this.info);
            }
            catch (Exception e) {
                logger.error("checkFolderAndFileInfoToDB failed", (Throwable)e);
                int deleteResult = this.storageClientExt.delete_file(this.info.getFileGroup(), this.info.getFileId());
                if (deleteResult == 0) {
                    this.info.setStatus(-1);
                    this.info.setPs("FastDFS Folder not exist.");
                } else {
                    logger.error("FastDfs Error Msg: folder not exists: {},{}, delete file error ret:{}, file: {},{}", new Object[]{FastDfsFileClientCommand.this.serverId, this.info.getFilePath(), deleteResult, this.info.getFileGroup(), this.info.getFileId()});
                    this.info.setStatus(-1);
                    this.info.setPs("FastDFS Folder not exists & Delete file error.");
                }
                throw new IOException(this.info.getPs());
            }
        }

        public void closeOverLimitError() throws IOException {
            try {
                if (this.remainSize > 0L) {
                    this.storageClientExt.closeAll();
                } else if (this.remainSize == 0L) {
                    String remoteFilename;
                    Map<String, String> out = this.storageClientExt.finishUpload();
                    String groupName = out.get("GROUP_NAME");
                    if (this.storageClientExt.delete_file(groupName, remoteFilename = out.get("REMOTE_FILENAME")) != 0) {
                        throw new IOException("FastDfs Error Msg: data sent is overlimited and clear data file error !");
                    }
                } else {
                    this.storageClientExt.closeAll();
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.storageClientExt.closeStorageServer();
            }
            throw new IOException("FastDfs Error Msg: data sent is overlimited.");
        }
    }
}

