/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler.impl;

import cn.com.yusys.yusp.commons.exception.ExceptionMessage;
import cn.com.yusys.yusp.commons.exception.YuspExceptionSendUtils;
import cn.com.yusys.yusp.commons.exception.web.BizException;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionAfterHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.utils.ExceptionUtils;
import java.util.Optional;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ExceptionHandlerImpl
extends IExceptionHandler<Exception> {
    private IExceptionAfterHandler exceptionAfterHandler;
    private String severExceptionMessage;

    public ExceptionHandlerImpl(IExceptionAfterHandler exceptionAfterHandler) {
        this.exceptionAfterHandler = exceptionAfterHandler;
    }

    public String getSeverExceptionMessage() {
        return this.severExceptionMessage;
    }

    public void setSeverExceptionMessage(String severExceptionMessage) {
        this.severExceptionMessage = severExceptionMessage;
    }

    @Override
    public Object handleException(Exception exception) {
        BizException t;
        if (exception instanceof BizException && (t = (BizException)exception).isSend()) {
            this.processBizStoreException(t);
        }
        ExceptionMessage exceptionMessage = this.parseExceptionMessage(exception);
        return this.writeExceptionToResponse(exceptionMessage, exception);
    }

    private void processBizStoreException(BizException bizException) {
        YuspExceptionSendUtils.send(bizException);
    }

    protected ExceptionMessage parseExceptionMessage(Exception exception) {
        String code = "500";
        String message = this.severExceptionMessage;
        if (StringUtils.isEmpty((CharSequence)message) && null == (message = ExceptionUtils.getExceptionMessage((Throwable)exception))) {
            message = "[\u672a\u77e5\u5f02\u5e38]," + exception.getClass().getName();
        }
        if (exception instanceof BizException) {
            BizException exceptionT = (BizException)exception;
            code = exceptionT.getErrorCode();
            message = exceptionT.getMessage();
        }
        if (exception instanceof DataAccessException) {
            message = "sql error!";
        }
        ExceptionMessage exceptionMessage = new ExceptionMessage();
        exceptionMessage.setCode(code);
        exceptionMessage.setMessage(message);
        return exceptionMessage;
    }

    protected Object writeExceptionToResponse(ExceptionMessage exceptionMessage, Exception exception) {
        if (null != this.exceptionAfterHandler) {
            return this.exceptionAfterHandler.handleException(exceptionMessage.getCode(), exceptionMessage.getMessage(), exception);
        }
        return null;
    }

    @Override
    public boolean shouldFilter(Exception exception) {
        return true;
    }

    @Override
    public void tag(Exception exception) {
        if (exception instanceof BizException) {
            BizException exceptionT = (BizException)exception;
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            Optional.ofNullable(attributes).map(ServletRequestAttributes::getResponse).ifPresent(response -> {
                response.addHeader("exception-class", BizException.class.getName());
                response.addHeader("exception-code", exceptionT.getI18nCode());
                response.addHeader("exception-message", exceptionT.getMessage());
                response.addHeader("exception-error", exceptionT.getErrorCode());
            });
        }
    }
}

