/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web;

import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class ExceptionTranslator {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionTranslator.class);
    private List<IExceptionHandler<? extends Exception>> exceptionHandlers;

    public ExceptionTranslator(List<IExceptionHandler<? extends Exception>> exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Object processException(Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        if (CollectionUtils.nonEmpty(this.exceptionHandlers)) {
            for (IExceptionHandler<? extends Exception> exceptionHandler : this.exceptionHandlers) {
                if (!exceptionHandler.shouldFilter(e)) continue;
                exceptionHandler.tag(e);
                if (logger.isDebugEnabled()) {
                    logger.debug("class {} to handler exception {}", exceptionHandler, e.getClass());
                }
                Object handlerResult = this.doHandleException(exceptionHandler, e);
                return handlerResult;
            }
        } else {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    Object doHandleException(IExceptionHandler exceptionHandler, Exception e) {
        return exceptionHandler.handleException(e);
    }
}

