/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.send;

import cn.com.yusys.yusp.commons.exception.send.LogData;
import cn.com.yusys.yusp.commons.exception.send.LogSendInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public class LogSend
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LogSend.class);
    private static LinkedBlockingDeque<LogData> QUEUES = new LinkedBlockingDeque(100000);
    private final ExecutorService executors = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        Thread logSendThread = new Thread(r, "log-send-thread");
        logSendThread.setDaemon(true);
        return logSendThread;
    });
    private static final int POOL_SIZE = 1;
    private LogSendInterface opLogSendInterface;
    private volatile boolean run = false;

    public void addLog(LogData logData) {
        if (!QUEUES.offer(logData)) {
            LOG.error("queue is full, do not send:{}", (Object)logData);
        }
    }

    public LogSend(LogSendInterface opLogSendInterface) {
        this.opLogSendInterface = opLogSendInterface;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.run = true;
        this.executors.execute(new SendThread());
        LOG.info("log-send-thread started");
    }

    public void destroy() {
        this.run = false;
        this.executors.shutdown();
        LOG.info("log-send-thread shutdown");
    }

    private class SendThread
    implements Runnable {
        private final ArrayList<LogData> buffer = new ArrayList(10);
        private int batch = 10;
        int count = 0;

        private SendThread() {
        }

        @Override
        public void run() {
            while (LogSend.this.run) {
                try {
                    this.sendBuffer();
                    this.count = 0;
                }
                catch (InterruptedException e) {
                    if (LogSend.this.run) continue;
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOG.error("log-send-thread error wait 1 m", (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                        ++this.count;
                        if (this.count < 3) continue;
                        this.buffer.clear();
                        this.count = 0;
                        LOG.error("\u5f53\u524d\u5f02\u5e38\u65e5\u5fd7\u53d1\u9001\u6b21\u6570\u5df2\u8fbe\u4e09\u6b21\uff0c\u4e22\u5f03\u5f53\u524d\u5f02\u5e38\u65e5\u5fd7\uff01\u53d1\u9001\u63a5\u53e3\u5f02\u5e38\u4e3a\uff1a", (Throwable)e);
                    }
                    catch (InterruptedException ex) {
                        if (LogSend.this.run) continue;
                        Thread.currentThread().interrupt();
                    }
                }
            }
            LOG.info("log-send-thread stoped");
        }

        private void sendBuffer() throws InterruptedException {
            LogData d;
            if (!this.buffer.isEmpty()) {
                this.send(this.buffer);
                this.buffer.clear();
            }
            if (null != (d = (LogData)QUEUES.poll(10L, TimeUnit.SECONDS))) {
                this.buffer.add(d);
                while (null != (d = (LogData)QUEUES.poll())) {
                    if (this.buffer.size() == this.batch) {
                        this.send(this.buffer);
                        this.buffer.clear();
                    }
                    this.buffer.add(d);
                }
                this.send(this.buffer);
                this.buffer.clear();
            }
        }

        private void send(List<LogData> data) {
            LogSend.this.opLogSendInterface.send(data);
        }
    }
}

