/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler.impl;

import cn.com.yusys.yusp.commons.biz.adapter.DefaultError;
import cn.com.yusys.yusp.commons.biz.bizlog.BizExceptionLog;
import cn.com.yusys.yusp.commons.biz.bizlog.IBizExceptionLogSender;
import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.BizStoreException;
import cn.com.yusys.yusp.commons.exception.StoreException;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import cn.com.yusys.yusp.commons.utils.ExceptionUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExceptionLogImpl
extends IExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionLogImpl.class);
    @Autowired
    private IBizExceptionLogSender sender;

    public Object handleException(Exception exception) {
        int excepFlag = 0;
        if (exception instanceof BizStoreException) {
            excepFlag = 1;
        } else if (exception instanceof StoreException) {
            excepFlag = 2;
        }
        BizException bizException = ExceptionUtils.tryFindYuspBizException((Throwable)exception);
        if (Objects.nonNull(bizException)) {
            this.processYuspBizException(bizException);
        } else {
            log.error(exception.getMessage(), (Throwable)exception);
        }
        if (excepFlag == 1) {
            this.processBizStoreException((BizStoreException)exception);
        } else if (excepFlag == 2) {
            this.processPlatStoreException((StoreException)exception);
        }
        return DefaultError.builder().error(((BizStoreException)exception).getCode()).message(exception.getMessage()).timestamp(DateUtils.formatDateTimeByDef()).build();
    }

    private void processYuspBizException(BizException yuspBizException) {
        String info = yuspBizException.getErrorCode() + ":" + yuspBizException.getMessage();
        if (BizBaseException.BIZ_LEVEL.ERROR.equals((Object)yuspBizException.getLevel())) {
            log.error(info, (Throwable)yuspBizException);
        } else if (BizBaseException.BIZ_LEVEL.WARN.equals((Object)yuspBizException.getLevel())) {
            log.warn(info, (Throwable)yuspBizException);
        } else {
            log.info(info);
        }
    }

    private void processPlatStoreException(StoreException exception) {
        if (this.sender != null) {
            BizExceptionLog bizLog = new BizExceptionLog();
            bizLog.setBizTradeNum(exception.getBizNum());
            bizLog.setFuncNum(exception.getFuncNum());
            bizLog.setExcepDesc(exception.getMessage());
            this.sender.send(bizLog);
        }
    }

    private void processBizStoreException(BizStoreException bizStoreException) {
        if (this.sender != null) {
            this.sender.send(bizStoreException.getBizLog());
        }
    }

    public Throwable getBizStoreException(Throwable exception) {
        if (null == exception) {
            return null;
        }
        Throwable cause = exception.getCause();
        if (null == cause) {
            return null;
        }
        if (cause instanceof BizStoreException) {
            return cause;
        }
        return this.getBizStoreException(cause);
    }

    @Override
    public boolean shouldFilter(Exception exception) {
        return exception instanceof BizStoreException || exception instanceof StoreException;
    }
}

