/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.rest;

import cn.com.yusys.yusp.commons.exception.BizBaseException;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.rest.AbstractClientHttpRequestInterceptor;
import cn.com.yusys.yusp.commons.utils.ExceptionUtils;
import java.io.IOException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;

public class BizExceptionResponseInterceptor
extends AbstractClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BizExceptionResponseInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClientHttpResponse intercept(@NonNull HttpRequest request, @NonNull byte[] body, @NonNull ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response = super.intercept(request, body, execution);
        String exceptionClass = BizExceptionResponseInterceptor.getExceptionInfo("exception-class", response);
        try {
            if (ExceptionUtils.isBizException((String)exceptionClass)) {
                log.debug("Rest Template response is Biz Exception.");
                String code = BizExceptionResponseInterceptor.getExceptionInfo("exception-code", response);
                String message = BizExceptionResponseInterceptor.getExceptionInfo("exception-message", response);
                message = URLDecoder.decode(message, "UTF-8");
                throw new BizBaseException(code, message, new Object[0]);
            }
            if (ExceptionUtils.isPlatformException((String)exceptionClass)) {
                String message = URLDecoder.decode(BizExceptionResponseInterceptor.getExceptionInfo("exception-message", response), "UTF-8");
                throw new PlatformException(message);
            }
        }
        finally {
            response.close();
        }
        return response;
    }

    public static String getExceptionInfo(String key, ClientHttpResponse response) {
        return ExceptionUtils.getExceptionInfo((Object)response, (T r) -> r.getHeaders().get((Object)key));
    }
}

