/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler.impl;

import cn.com.yusys.yusp.commons.biz.adapter.DefaultError;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.exception.web.handler.ExceptionHandler;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Optional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class PlatformExceptionHandler
implements ExceptionHandler<PlatformException> {
    @Override
    public Object handleException(PlatformException exception) {
        this.addResponseHeaderException(null, exception.getMessage());
        return DefaultError.builder().error("500").message(exception.getMessage()).timestamp(DateUtils.formatDateTimeByDef()).build();
    }

    public boolean isSupported(Exception e) {
        return PlatformException.class.isAssignableFrom(e.getClass());
    }

    @Override
    public void addResponseHeaderException(String code, String message) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Optional.ofNullable(attributes).map(ServletRequestAttributes::getResponse).ifPresent(response -> {
            try {
                response.addHeader("exception-message", URLEncoder.encode(message, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

