/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler.impl;

import cn.com.yusys.yusp.commons.biz.adapter.DefaultError;
import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.web.handler.ExceptionHandler;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class BizExceptionHandler
implements ExceptionHandler<BizException> {
    private final int responseStatus;
    private final boolean handleFeign;
    public static final String EXCEPTION_ERROR_CODE = "exception-error";

    public BizExceptionHandler(int responseStatus, boolean handleFeign) {
        this.responseStatus = responseStatus;
        this.handleFeign = handleFeign;
    }

    @Override
    public Object handleException(BizException exception) {
        if (this.handleFeign) {
            AtomicReference isFeignRequest = new AtomicReference();
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            Optional.ofNullable(attributes).map(ServletRequestAttributes::getRequest).ifPresent(request -> isFeignRequest.set(request.getHeader("feign-request")));
            if (isFeignRequest.get() != null) {
                throw exception;
            }
        }
        return DefaultError.builder().error(exception.getErrorCode()).message(exception.getMessage()).timestamp(DateUtils.formatDateTimeByDef()).build();
    }

    public boolean isSupported(Exception exception) {
        return exception instanceof BizException;
    }

    @Override
    public void tag(BizException bizException) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Optional.ofNullable(attributes).map(ServletRequestAttributes::getResponse).ifPresent(response -> {
            response.addHeader("exception-class", BizException.class.getName());
            response.setStatus(this.responseStatus);
            response.addHeader("exception-code", bizException.getI18nCode());
            response.addHeader("exception-message", bizException.getMessage());
            response.addHeader(EXCEPTION_ERROR_CODE, bizException.getErrorCode());
        });
    }
}

