/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.web.handler;

import cn.com.yusys.yusp.commons.core.Supported;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public interface ExceptionHandler<T extends Exception>
extends Supported<Exception> {
    public static final String EXCEPTION_CODE = "exception-code";
    public static final String EXCEPTION_MESSAGE = "exception-message";
    public static final String EXCEPTION_CLASS = "exception-class";
    public static final String EXCEPTION_TRACEID = "exception-traceid";
    public static final String UNKNOWN_CODE = "unknown_code";

    public Object handleException(T var1);

    default public void tag(T exception) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Optional.ofNullable(attributes).map(ServletRequestAttributes::getResponse).ifPresent(response -> {
            response.addHeader(EXCEPTION_CLASS, exception.getClass().getName());
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        });
    }

    default public void addResponseHeaderException(String code, String message) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        Optional.ofNullable(attributes).map(ServletRequestAttributes::getResponse).ifPresent(response -> {
            try {
                response.addHeader(EXCEPTION_CODE, code);
                response.addHeader(EXCEPTION_MESSAGE, URLEncoder.encode(message, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

