/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.exception.fegin;

import cn.com.yusys.yusp.commons.exception.BizException;
import cn.com.yusys.yusp.commons.exception.PlatformException;
import cn.com.yusys.yusp.commons.exception.util.ExceptionUtils;
import feign.FeignException;
import feign.Response;
import feign.codec.ErrorDecoder;
import java.net.URLDecoder;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignErrorDecoder
implements ErrorDecoder {
    private final Logger logger = LoggerFactory.getLogger(FeignErrorDecoder.class);

    public Exception decode(String methodKey, Response response) {
        String exceptionClass = FeignErrorDecoder.getExceptionInfo("exception-class", response);
        if (ExceptionUtils.isBizException(exceptionClass)) {
            try {
                String code = FeignErrorDecoder.getExceptionInfo("exception-code", response);
                String message = FeignErrorDecoder.getExceptionInfo("exception-message", response);
                String errorCode = FeignErrorDecoder.getExceptionInfo("exception-error", response);
                message = URLDecoder.decode(message, "UTF-8");
                return BizException.error(code, errorCode, message);
            }
            catch (Exception e) {
                this.logger.warn("500 feign decoder exception error.");
            }
        } else if (ExceptionUtils.isPlatformException(exceptionClass)) {
            try {
                String message = URLDecoder.decode(FeignErrorDecoder.getExceptionInfo("exception-message", response), "UTF-8");
                return new PlatformException(message);
            }
            catch (Exception e) {
                this.logger.warn("500 feign decoder exception error.");
            }
        }
        return FeignException.errorStatus((String)methodKey, (Response)response);
    }

    static String getExceptionInfo(String key, Response response) {
        return ExceptionUtils.getExceptionInfo(response, (T r) -> (Collection)r.headers().get(key));
    }
}

