/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.util;

import cn.com.yusys.yusp.commons.excelcsv.BillTemplate;
import cn.com.yusys.yusp.commons.module.standard.Dicts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.jxls.transform.poi.WritableHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class CommonFunctions {
    private static final Logger log = LoggerFactory.getLogger(CommonFunctions.class);

    public String dict(String src, String lookupCode) {
        return this.translateDict(lookupCode, src);
    }

    public String dict(String src, String lookupCode, String defaultValue) {
        String translateValue = this.translateDict(lookupCode, src);
        return translateValue.equals(src) ? defaultValue : translateValue;
    }

    public WritableHyperlink makeLink(Object obj, String value, String targetSheetName, String keyFields) {
        String address = "'" + targetSheetName + "'!" + BillTemplate.keyFields2Key(obj, keyFields);
        return new WritableHyperlink(address, value, HyperlinkType.DOCUMENT);
    }

    private String translateDict(String dictCode, String srcValue) {
        if (StringUtils.isBlank((CharSequence)dictCode) || StringUtils.isBlank((CharSequence)srcValue)) {
            return srcValue;
        }
        String[] dictAndLang = dictCode.split("\\$");
        dictCode = dictAndLang[0];
        Locale locale = dictAndLang.length == 1 ? LocaleContextHolder.getLocale() : Optional.ofNullable(dictAndLang[1]).map(lang -> StringUtils.replace((String)lang, (String)"_", (String)"-")).map(Locale::forLanguageTag).orElseGet(LocaleContextHolder::getLocale);
        return Optional.ofNullable(Dicts.fromThreadLocal().valueOf(dictCode, srcValue, locale, true)).map(dict -> dict.stream().map(item -> item.itemName(locale)).collect(Collectors.joining(","))).orElse(srcValue);
    }
}

