/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeConverter
implements Converter<LocalDateTime> {
    private DateTimeFormatter formatter;
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public LocalDateTimeConverter() {
        this.formatter = DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT);
    }

    public LocalDateTimeConverter(String format) {
        this.formatter = format != null && !format.isEmpty() ? DateTimeFormatter.ofPattern(format) : DateTimeFormatter.ofPattern(DEFAULT_DATE_TIME_FORMAT);
    }

    public Class<LocalDateTime> supportJavaTypeKey() {
        return LocalDateTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return null;
    }

    public LocalDateTime convertToJavaData(CellData cellData, ExcelContentProperty property, GlobalConfiguration globalConfiguration) throws Exception {
        if (cellData.getStringValue() == null || cellData.getStringValue().isEmpty()) {
            return null;
        }
        return LocalDateTime.parse(cellData.getStringValue(), this.formatter);
    }

    public WriteCellData<?> convertToExcelData(LocalDateTime localDateTime, ExcelContentProperty property, GlobalConfiguration globalConfiguration) throws Exception {
        if (localDateTime == null) {
            return new WriteCellData("");
        }
        return new WriteCellData(this.formatter.format(localDateTime));
    }
}

