/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.async;

import cn.com.yusys.yusp.commons.excelcsv.async.AsyncExecutor;
import cn.com.yusys.yusp.commons.excelcsv.async.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringTransaction
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(SpringTransaction.class);
    private final DataSourceTransactionManager transactionManager;

    public SpringTransaction(DataSourceTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void execute(AsyncExecutor execute) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)def);
        try {
            execute.execute();
            this.transactionManager.commit(transaction);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transaction);
            logger.error("Deal exception, cause by:{}, transaction rollback!", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

