/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.model;

import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CustomDefine {
    private boolean replaceHead = true;
    private Map<String, String[]> heads = new HashMap<String, String[]>();
    private Set<String> includeFeilds = new HashSet<String>();
    private Set<String> excludeFeilds = new HashSet<String>();

    public CustomDefine(boolean replaceHead) {
        this.replaceHead = replaceHead;
    }

    public static CustomDefine of(boolean replaceHead) {
        return new CustomDefine(replaceHead);
    }

    public static CustomDefine of() {
        return new CustomDefine(true);
    }

    public CustomDefine head(String key, String[] head) {
        if (head != null) {
            this.heads.put(key, head);
        }
        return this;
    }

    public CustomDefine heads(Map<String, String[]> heads) {
        if (heads != null) {
            this.heads.putAll(heads);
        }
        return this;
    }

    public CustomDefine includeFeilds(Set<String> includeFeilds) {
        if (CollectionUtils.nonEmpty(includeFeilds)) {
            this.includeFeilds.addAll(includeFeilds);
        }
        return this;
    }

    public CustomDefine excludeFeilds(Set<String> excludeFeilds) {
        if (CollectionUtils.nonEmpty(excludeFeilds)) {
            this.excludeFeilds.addAll(excludeFeilds);
        }
        return this;
    }

    public boolean isReplaceHead() {
        return this.replaceHead;
    }

    public void setReplaceHead(boolean replaceHead) {
        this.replaceHead = replaceHead;
    }

    public Map<String, String[]> getHeads() {
        return this.heads;
    }

    public String[] getHead(String key) {
        return this.heads.get(key);
    }

    public Set<String> getIncludeFeilds() {
        return this.includeFeilds;
    }

    public Set<String> getExcludeFeilds() {
        return this.excludeFeilds;
    }

    public String toString() {
        return "CustomDefine{replaceHead=" + this.replaceHead + ", heads=" + this.heads + ", includeFeilds=" + this.includeFeilds + ", excludeFeilds=" + this.excludeFeilds + '}';
    }
}

