/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.handle.impl;

import cn.com.yusys.yusp.commons.excelcsv.annotation.ExcelField;
import cn.com.yusys.yusp.commons.excelcsv.handle.DataHandle;
import cn.com.yusys.yusp.commons.excelcsv.handle.ExcelCsvHead;
import cn.com.yusys.yusp.commons.excelcsv.model.FieldInfo;
import cn.com.yusys.yusp.commons.module.standard.DictItem;
import cn.com.yusys.yusp.commons.module.standard.Dicts;
import cn.com.yusys.yusp.commons.util.ReflectionUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class AbstractExcelFieldDataHandle
implements DataHandle {
    private static final Class<?>[] BASIC_NUM_TYPE = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] NORMAL_DATA_TYPE = new Class[]{Date.class, LocalDate.class, LocalDateTime.class, Timestamp.class};
    private final Map<Class<?>, List<FieldInfo>> CACHE = new HashMap(4);
    private Object customParam;

    @Override
    public Object handle(Object obj, DataHandle.OperationType opType) {
        if (obj == null) {
            return null;
        }
        Locale locale = LocaleContextHolder.getLocale();
        this.doTranslate(obj, locale, opType);
        return this.doHandle(obj);
    }

    private void doTranslate(Object obj, Locale locale, DataHandle.OperationType opType) {
        List<FieldInfo> fieldInfos = this.CACHE.get(obj.getClass());
        if (fieldInfos != null && !fieldInfos.isEmpty()) {
            fieldInfos.forEach(fieldInfo -> {
                if (StringUtils.nonEmpty((CharSequence)fieldInfo.getDictCode())) {
                    String transValue = this.translate(fieldInfo.getDictCode(), StringUtils.replaceObjNull((Object)ReflectionUtils.getPropertyValue((Object)obj, (Field)fieldInfo.getField())), locale, opType);
                    ReflectionUtils.setPropertyValue((Object)obj, (Field)fieldInfo.getField(), (Object)transValue);
                }
            });
        }
    }

    private String translate(String dictCode, String srcValue, Locale locale, DataHandle.OperationType opType) {
        if (dictCode == null || srcValue == null) {
            return srcValue;
        }
        DictItem item = Dicts.fromThreadLocal().valueOf(dictCode, srcValue, locale, opType == DataHandle.OperationType.EXPORT);
        return this.getTranslateValue(item, srcValue, locale, opType);
    }

    private String getTranslateValue(DictItem dictItem, String srcValue, Locale locale, DataHandle.OperationType opType) {
        if (dictItem == null) {
            return srcValue;
        }
        if (opType == DataHandle.OperationType.EXPORT) {
            return dictItem.itemName(locale);
        }
        return dictItem.itemCode();
    }

    public abstract Object doHandle(Object var1);

    public LinkedList<ExcelCsvHead> analysis(Class<?> headClass) {
        if (headClass == null) {
            throw new IllegalArgumentException("headClass can not be null");
        }
        List fieldInfos = this.CACHE.computeIfAbsent(headClass, head -> this.getFieldInfos(headClass));
        LinkedList<ExcelCsvHead> excelCsvHeads = new LinkedList<ExcelCsvHead>();
        fieldInfos.forEach(fieldInfo -> excelCsvHeads.add(this.createExcelCsvHead((FieldInfo)fieldInfo)));
        return excelCsvHeads;
    }

    private List<FieldInfo> getFieldInfos(Class<?> headClass) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        ReflectionUtils.getFields(headClass, (boolean)true, (boolean)true).forEach(field -> {
            FieldInfo fieldInfo = field.isAnnotationPresent(ExcelField.class) ? new FieldInfo((Field)field, field.getAnnotation(ExcelField.class)) : new FieldInfo((Field)field);
            boolean isShow = this.dynamicColumnShow(this.customParam, headClass, (Field)field);
            if (!isShow) {
                fieldInfo.setOrder(-1);
            }
            fieldInfos.add(fieldInfo);
        });
        return this.assignOrder(fieldInfos);
    }

    public boolean dynamicColumnShow(Object customParam, Class<?> headClass, Field field) {
        return true;
    }

    private List<FieldInfo> assignOrder(List<FieldInfo> fieldInfos) {
        int position;
        ArrayList<FieldInfo> orderedFieldInfo = new ArrayList<FieldInfo>();
        ArrayList<Integer> alreadyOrder = new ArrayList<Integer>();
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getOrder() > 0) {
                position = this.getOrder(alreadyOrder, fieldInfo.getOrder(), fieldInfo.getOrder());
                alreadyOrder.add(position);
                fieldInfo.setOrder(position);
                orderedFieldInfo.add(fieldInfo);
            }
            if (fieldInfo.getOrder() >= 0) continue;
            orderedFieldInfo.add(fieldInfo);
        }
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getOrder() != 0) continue;
            position = this.getOrder(alreadyOrder, 0, fieldInfo.getOrder());
            alreadyOrder.add(position);
            fieldInfo.setOrder(position);
            orderedFieldInfo.add(fieldInfo);
        }
        return orderedFieldInfo;
    }

    private int getOrder(List<Integer> alreadyOrder, int index, int currentOrder) {
        if (!alreadyOrder.contains(currentOrder)) {
            return currentOrder;
        }
        if (!alreadyOrder.contains(index)) {
            return index;
        }
        int position = index;
        while (alreadyOrder.contains(++position)) {
        }
        return position;
    }

    private ExcelCsvHead createExcelCsvHead(FieldInfo fieldInfo) {
        String dict = null;
        if (fieldInfo.getDictCode() != null && !fieldInfo.getDictCode().isEmpty()) {
            dict = fieldInfo.getDictCode();
        }
        ExcelCsvHead.FormatType formatType = null;
        String formatPattern = "";
        if (fieldInfo.getFormat() != null && !fieldInfo.getFormat().isEmpty()) {
            Class<?> fieldType = fieldInfo.getField().getType();
            ExcelCsvHead.FormatType formatType2 = AbstractExcelFieldDataHandle.isDateType(fieldType) ? ExcelCsvHead.FormatType.DATE : (formatType = Number.class.isAssignableFrom(fieldType) || AbstractExcelFieldDataHandle.isBasicNum(fieldType) ? ExcelCsvHead.FormatType.NUM : null);
            formatPattern = fieldInfo.getFormat().isEmpty() ? (formatType == ExcelCsvHead.FormatType.DATE ? DateUtils.PATTERN_DATETIME : "") : fieldInfo.getFormat();
        }
        return new ExcelCsvHead(fieldInfo.getOrder(), fieldInfo.getName(), fieldInfo.getTitle(), fieldInfo.getViewLength(), formatType, formatPattern, dict, fieldInfo.getExportCellStyle());
    }

    private static boolean isBasicNum(Class<?> fieldType) {
        return Stream.of(BASIC_NUM_TYPE).anyMatch(type -> type == fieldType);
    }

    private static boolean isDateType(Class<?> fieldType) {
        return Stream.of(NORMAL_DATA_TYPE).anyMatch(type -> type == fieldType);
    }

    @Override
    public void setCustomParam(Object customParam) {
        this.customParam = customParam;
    }
}

