/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.async;

import cn.com.yusys.yusp.commons.excelcsv.async.ExportContext;
import cn.com.yusys.yusp.commons.excelcsv.async.I18nAsyncTask;
import cn.com.yusys.yusp.commons.excelcsv.model.IterableModel;
import cn.com.yusys.yusp.commons.progress.model.ProgressDto;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.BeanUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAsyncTask
extends I18nAsyncTask {
    private static final Logger log = LoggerFactory.getLogger(ExportAsyncTask.class);
    private final ExportContext exportContext;
    private final int maxPages;
    private final int pageSize;
    private final ProgressDto progressDto;
    private static final String REDIS_GROUP_PREFIX = "ExcelCsvTask";
    private static final String SPLIT_SYMBOL = ":";
    private static final int TOTAL_TASK = 100;
    private static final int TASK_START = 0;

    public ExportAsyncTask(ExportContext exportContext, int maxPages, int pageSize) {
        Asserts.nonNull((Object)exportContext, (Object[])new Object[]{"Export context must not null!"});
        Asserts.nonNull((Object)exportContext.getDataAcquisition(), (Object[])new Object[]{"Data acquisition object must not null!"});
        this.exportContext = exportContext;
        this.maxPages = maxPages;
        this.pageSize = pageSize <= 0 ? 5000 : pageSize;
        this.progressDto = ProgressDto.of((String)StringUtils.uuid((boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRun() {
        File outFile = null;
        boolean needDelete = false;
        try {
            String taskId = this.progressDto.getTaskId();
            log.info("start export, taskId is [{}]", (Object)taskId);
            this.reportProgress(this.progressDto);
            outFile = this.exportTask();
            log.info("async task:{} export finished. temporary file is:{}", (Object)this.progressDto.getTaskId(), (Object)outFile.getAbsolutePath());
            String fileInfoIdentity = this.exportContext.getExportPostProcessor().postProcessor(outFile);
            log.info("async task:{} file export post processor return file is:{}", (Object)this.progressDto.getTaskId(), (Object)fileInfoIdentity);
            needDelete = !Objects.equals(fileInfoIdentity, outFile.getAbsolutePath());
            this.progressDto.setProgressBar(100);
            this.progressDto.setFileId(fileInfoIdentity);
            this.reportProgress(this.progressDto);
        }
        catch (Throwable e) {
            log.error("async task:" + this.progressDto.getTaskId() + " occur error!", e);
            this.progressDto.setProgressBar(-1);
            this.reportProgress(this.progressDto);
        }
        finally {
            if (outFile != null && needDelete && outFile.exists() && !outFile.delete()) {
                log.warn("temp file {} delete failed, please delete manually.", (Object)outFile.getPath());
            }
        }
    }

    void reportProgress(ProgressDto progressDto) {
        Map map = BeanUtils.beanToMap((Object)progressDto);
        String key = progressDto.getTaskId();
        this.exportContext.progress.report(key, progressDto.getProgressBar(), 100, map);
    }

    public File exportTask() {
        IterableModel model = new IterableModel(this::queryResultByPage, this.maxPages, this.pageSize);
        return this.exportContext.getExporterImporter().export(this.exportContext.getHeadClass(), model, this.exportContext.getDataHandle(), this.exportContext.getCustomDefine());
    }

    private Collection<?> queryResultByPage(int pageNum, int pageSize) {
        try {
            Collection<?> resultModel = this.exportContext.getDataAcquisition().getData(pageNum, pageSize, this.exportContext.getQueryCondition());
            int percent = 0;
            if (this.maxPages > 0) {
                percent = (int)((double)pageNum / (double)this.maxPages * 100.0);
            } else if (this.exportContext.getTotalAcquisition() == null) {
                percent = 90;
            } else {
                long totalNum = this.exportContext.getTotalAcquisition().getTotal(this.exportContext.getQueryCondition());
                percent = (int)((double)pageNum / ((double)totalNum / (double)pageSize) * 100.0);
                this.progressDto.setTotalRecord(totalNum);
            }
            this.progressDto.setProgressBar(percent == 100 ? 99 : percent);
            long alreadyCount = this.progressDto.getProcessRecord();
            this.progressDto.setProcessRecord(alreadyCount + (long)resultModel.size());
            this.reportProgress(this.progressDto);
            return resultModel;
        }
        catch (Exception e) {
            this.progressDto.setProgressBar(-1);
            this.reportProgress(this.progressDto);
            log.error("error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public ProgressDto getProgressDto() {
        return this.progressDto;
    }
}

