/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.util;

import cn.com.yusys.yusp.commons.excelcsv.handle.ExcelCsvHead;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.date.DateUtils;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.reflect.FastClass;
import org.apache.poi.ss.usermodel.DateUtil;

public class RecordInfo {
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ConcurrentHashMap<Class<?>, RecordInfo> CACHE = new ConcurrentHashMap();
    private final List<ExcelCsvHead> fieldInfos;
    private final String[] fieldTitles;
    private final List<Function<Object, Object>> valueGetters;
    private final List<BiFunction<Object, Map<String, Object>, Object>> beanSetters;
    private final FastClass fastClass;
    private static Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+\\.*[0-9]*");

    public static RecordInfo of(Class<?> recordClass, List<ExcelCsvHead> fieldInfos) {
        Objects.requireNonNull(recordClass, "record class can not be null.");
        Objects.requireNonNull(fieldInfos, "fieldInfos can not be null.");
        if (fieldInfos.isEmpty()) {
            throw new IllegalArgumentException("fields info can not be empty.");
        }
        return CACHE.computeIfAbsent(recordClass, reClass -> new RecordInfo((Class<?>)reClass, fieldInfos));
    }

    private RecordInfo(Class<?> recordClass, List<ExcelCsvHead> fieldInfos) {
        Map<String, PropertyDescriptor> propertyMap = Arrays.stream(ReflectUtils.getBeanGetters(recordClass)).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
        this.fieldInfos = fieldInfos.stream().sorted(Comparator.comparing(ExcelCsvHead::getColumnIndex)).collect(Collectors.toList());
        this.fastClass = FastClass.create(recordClass);
        this.valueGetters = this.createValueGetters(propertyMap);
        this.fieldTitles = (String[])this.fieldInfos.stream().map(ExcelCsvHead::getTitle).toArray(String[]::new);
        this.beanSetters = this.createBeanSetters(propertyMap);
    }

    private List<Function<Object, Object>> createValueGetters(Map<String, PropertyDescriptor> propertyMap) {
        ArrayList<Function<Object, Object>> getters = new ArrayList<Function<Object, Object>>();
        this.fieldInfos.forEach(excelCsvHead -> {
            PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(excelCsvHead.getFieldName());
            int index = this.fastClass.getIndex(pd.getReadMethod().getName(), (Class[])pd.getReadMethod().getParameterTypes());
            if (excelCsvHead.getFormatType() != null) {
                getters.add(this.createValueGetters(index, excelCsvHead.getFormatType(), excelCsvHead.getFormat()));
            } else if (Date.class == pd.getPropertyType() || LocalDate.class == pd.getPropertyType() || LocalDateTime.class == pd.getPropertyType()) {
                getters.add(this.createValueGetters(index, ExcelCsvHead.FormatType.DATE, ""));
            } else {
                getters.add(this.createValueGetters(index));
            }
        });
        return getters;
    }

    private Function<Object, Object> createValueGetters(int methodIndex) {
        return obj -> {
            try {
                return this.fastClass.invoke(methodIndex, obj, EMPTY_ARGS);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("invoke value getter failed.", e);
            }
        };
    }

    private Function<Object, Object> createValueGetters(int methodIndex, ExcelCsvHead.FormatType formatType, String format) {
        return obj -> {
            try {
                Object value = this.fastClass.invoke(methodIndex, obj, EMPTY_ARGS);
                if (value == null) {
                    return null;
                }
                if (formatType == ExcelCsvHead.FormatType.DATE) {
                    if (value instanceof Date) {
                        Date date = (Date)value;
                        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
                        return DateTimeFormatter.ofPattern(StringUtils.isBlank((CharSequence)format) ? DEFAULT_DATE_TIME_FORMAT : format).format(localDateTime);
                    }
                    if (value instanceof LocalDate) {
                        return DateTimeFormatter.ofPattern(StringUtils.isBlank((CharSequence)format) ? DEFAULT_DATE_FORMAT : format).format((LocalDate)value);
                    }
                    if (value instanceof LocalDateTime) {
                        return DateTimeFormatter.ofPattern(StringUtils.isBlank((CharSequence)format) ? DEFAULT_DATE_TIME_FORMAT : format).format((LocalDateTime)value);
                    }
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
                    return decimalFormat.format(value);
                }
                return value;
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("invoke value getter failed.", e);
            }
        };
    }

    private List<BiFunction<Object, Map<String, Object>, Object>> createBeanSetters(Map<String, PropertyDescriptor> propertyMap) {
        ArrayList<BiFunction<Object, Map<String, Object>, Object>> setters = new ArrayList<BiFunction<Object, Map<String, Object>, Object>>();
        this.fieldInfos.forEach(excelCsvHead -> {
            PropertyDescriptor pd = (PropertyDescriptor)propertyMap.get(excelCsvHead.getFieldName());
            int methodIndex = this.fastClass.getIndex(pd.getWriteMethod().getName(), (Class[])pd.getWriteMethod().getParameterTypes());
            if (excelCsvHead.getFormatType() != null) {
                setters.add(this.createBeanSetters(methodIndex, excelCsvHead.getTitle(), pd.getPropertyType(), excelCsvHead.getFormatType(), excelCsvHead.getFormat()));
            } else {
                setters.add(this.createBeanSetters(methodIndex, excelCsvHead.getTitle(), pd.getPropertyType()));
            }
        });
        return setters;
    }

    private BiFunction<Object, Map<String, Object>, Object> createBeanSetters(int methodIndex, String title, Class<?> fieldType) {
        return (obj, valuesMap) -> {
            if (this.isNullValue((Map<String, Object>)valuesMap, title)) {
                return obj;
            }
            try {
                if (this.isBasicNumType(fieldType) || Number.class.isAssignableFrom(fieldType)) {
                    this.setNumFieldValue(methodIndex, obj, String.valueOf(valuesMap.get(title)), fieldType);
                } else if (Date.class == fieldType || LocalDate.class == fieldType || LocalDateTime.class == fieldType || Timestamp.class == fieldType) {
                    this.setDateTimeValue(methodIndex, obj, String.valueOf(valuesMap.get(title)), fieldType, "");
                } else if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                    this.setBoolFieldValue(methodIndex, obj, String.valueOf(valuesMap.get(title)));
                } else {
                    this.fastClass.invoke(methodIndex, obj, new Object[]{valuesMap.get(title)});
                }
                return obj;
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("invoke value setter failed.", e);
            }
        };
    }

    private BiFunction<Object, Map<String, Object>, Object> createBeanSetters(int methodIndex, String title, Class<?> fieldType, ExcelCsvHead.FormatType formatType, String format) {
        return (obj, valuesMap) -> {
            if (this.isNullValue((Map<String, Object>)valuesMap, title) || StringUtils.isBlank((CharSequence)String.valueOf(valuesMap.get(title)))) {
                return obj;
            }
            try {
                if (formatType == ExcelCsvHead.FormatType.DATE) {
                    this.setDateTimeValue(methodIndex, obj, String.valueOf(valuesMap.get(title)), fieldType, format);
                } else {
                    DecimalFormat decimalFormat = new DecimalFormat(format);
                    Number numValue = decimalFormat.parse(String.valueOf(valuesMap.get(title)));
                    this.setNumFieldValue(methodIndex, obj, String.valueOf(numValue), fieldType);
                }
                return obj;
            }
            catch (ParseException e) {
                throw new IllegalStateException("invoke value setter failed.", e);
            }
        };
    }

    private boolean isBasicNumType(Class<?> fieldType) {
        return Stream.of(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE).anyMatch(type -> type == fieldType);
    }

    private boolean isNullValue(Map<String, Object> valueMap, String key) {
        return valueMap == null || valueMap.isEmpty() || valueMap.get(key) == null || "null".equals(String.valueOf(valueMap.get(key)));
    }

    private void setNumFieldValue(int methodIndex, Object obj, String value, Class<?> fieldType) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        BigDecimal numValue = new BigDecimal(value);
        try {
            if (fieldType == Byte.TYPE || fieldType == Byte.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{numValue.byteValueExact()});
            } else if (fieldType == Short.TYPE || fieldType == Short.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{numValue.shortValueExact()});
            } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{numValue.intValueExact()});
            } else if (fieldType == Long.TYPE || fieldType == Long.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{numValue.longValueExact()});
            } else if (fieldType == Float.TYPE || fieldType == Float.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{Float.valueOf(numValue.floatValue())});
            } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{numValue.doubleValue()});
            } else if (fieldType == BigDecimal.class) {
                this.fastClass.invoke(methodIndex, obj, new Object[]{numValue});
            }
        }
        catch (ArithmeticException | InvocationTargetException e) {
            throw new IllegalStateException("invoke value setter failed.", e);
        }
    }

    private void setDateTimeValue(int methodIndex, Object obj, String value, Class<?> fieldType, String format) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        try {
            Comparable<ChronoLocalDate> paramObject;
            if (fieldType == LocalDate.class) {
                String dataFormat = format.isEmpty() ? DEFAULT_DATE_FORMAT : format;
                DateTimeFormatter dataFormatter = DateTimeFormatter.ofPattern(dataFormat);
                value = this.transferIfNumberDate(value, dataFormat);
                paramObject = LocalDate.parse(value, dataFormatter);
            } else if (fieldType == LocalDateTime.class) {
                String dataTimeFormat = format.isEmpty() ? DEFAULT_DATE_TIME_FORMAT : format;
                DateTimeFormatter dataTimeFormatter = DateTimeFormatter.ofPattern(dataTimeFormat);
                value = this.transferIfNumberDate(value, dataTimeFormat);
                paramObject = LocalDateTime.parse(value, dataTimeFormatter);
            } else if (fieldType == Timestamp.class) {
                String timeFormat = format.isEmpty() ? DateUtils.PATTERN_DATETIME : format;
                DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
                value = this.transferIfNumberDate(value, timeFormat);
                Instant instant = format.replaceAll("[^GyMDdHhmsS]", "").length() <= 8 && (format.contains("y") || format.contains("M") || format.contains("d")) ? LocalDate.from(timeFormatter.parse(value)).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant() : LocalDateTime.from(timeFormatter.parse(value)).atZone(ZoneId.systemDefault()).toInstant();
                paramObject = new Timestamp(Date.from(instant).getTime());
            } else {
                String dataFormat = format.isEmpty() ? DEFAULT_DATE_TIME_FORMAT : format;
                value = this.transferIfNumberDate(value, dataFormat);
                SimpleDateFormat sdf = new SimpleDateFormat(dataFormat);
                paramObject = sdf.parse(value);
            }
            this.fastClass.invoke(methodIndex, obj, new Object[]{paramObject});
        }
        catch (InvocationTargetException | ParseException e) {
            throw new IllegalStateException("invoke value setter failed.", e);
        }
    }

    private void setBoolFieldValue(int methodIndex, Object obj, String value) {
        if (value.isEmpty()) {
            return;
        }
        Boolean boolValue = "true".equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        try {
            this.fastClass.invoke(methodIndex, obj, new Object[]{boolValue});
        }
        catch (ArithmeticException | InvocationTargetException e) {
            throw new IllegalStateException("invoke value setter failed.", e);
        }
    }

    public Object[] readValues(Object record) {
        return this.valueGetters.stream().map(getter -> getter.apply(record)).toArray();
    }

    public Object writeValues(Class<?> recordClass, Map<String, Object> valuesMap) {
        Object bean = ReflectUtils.newInstance(recordClass);
        if (bean == null) {
            throw new IllegalStateException("create bean failed for class [" + recordClass.getName() + "]");
        }
        List<BiFunction<Object, Map<String, Object>, Object>> beanSetters = RecordInfo.CACHE.get(recordClass).beanSetters;
        if (beanSetters == null || beanSetters.isEmpty()) {
            throw new IllegalStateException("no suitable setters for class [" + recordClass.getName() + "]");
        }
        beanSetters.forEach(setter -> setter.apply(bean, valuesMap));
        return bean;
    }

    public String[] getFieldTitles() {
        return this.fieldTitles;
    }

    private String transferIfNumberDate(String value, String format) {
        String tempValue = value;
        if (this.dateNumberCheck(value)) {
            Date javaDate = DateUtil.getJavaDate((double)Double.parseDouble(value));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            tempValue = simpleDateFormat.format(javaDate);
        }
        return tempValue;
    }

    private boolean dateNumberCheck(String dateNumber) {
        Matcher isNum = NUMBER_PATTERN.matcher(dateNumber);
        return isNum.matches();
    }
}

