/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.handle.impl.adapter;

import cn.com.yusys.yusp.commons.excelcsv.handle.impl.adapter.CacheableLookupAdapter;
import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.DictFactory;
import cn.com.yusys.yusp.commons.module.standard.impl.DictImpl;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class OCALookupAdapterDictFactory
implements DictFactory {
    private static final Logger logger = LoggerFactory.getLogger(OCALookupAdapterDictFactory.class);
    private final CacheableLookupAdapter cacheableLookupAdapter;
    private final String version;

    public OCALookupAdapterDictFactory(CacheableLookupAdapter cacheableLookupAdapter, String version) {
        this.cacheableLookupAdapter = cacheableLookupAdapter;
        this.version = version;
    }

    public Dict create(String dictCode) {
        return this.create(dictCode, this.cacheableLookupAdapter.getLookup(dictCode, this.version));
    }

    private Dict create(String dictCode, Map<String, String> map) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        String locale = LocaleContextHolder.getLocale().toString();
        logger.info("Get lookup dict locale.Current locale is [{}]", (Object)locale);
        DictImpl dict = DictImpl.of((String)dictCode);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dict.addDictItem(locale, entry.getKey(), entry.getValue());
        }
        return dict;
    }
}

