/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelcsv.easyexcel;

import com.alibaba.excel.context.WriteContext;
import com.alibaba.excel.enums.WriteTypeEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.CellRange;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.NumberDataFormatterUtils;
import com.alibaba.excel.util.StringUtils;
import com.alibaba.excel.util.WorkBookUtil;
import com.alibaba.excel.util.WriteHandlerUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.WriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.alibaba.excel.write.property.ExcelWriteHeadProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YuWriteContextImpl
implements WriteContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(YuWriteContextImpl.class);
    private WriteWorkbookHolder writeWorkbookHolder;
    private WriteSheetHolder writeSheetHolder;
    private WriteHolder currentWriteHolder;
    private boolean finished = false;

    public YuWriteContextImpl(WriteWorkbook writeWorkbook) {
        if (writeWorkbook == null) {
            throw new IllegalArgumentException("Workbook argument cannot be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Begin to Initialization 'WriteContextImpl'");
        }
        this.initCurrentWorkbookHolder(writeWorkbook);
        WriteHandlerUtils.beforeWorkbookCreate((WriteContext)this);
        try {
            WorkBookUtil.createWorkBook((WriteWorkbookHolder)this.writeWorkbookHolder);
        }
        catch (Exception e) {
            throw new ExcelGenerateException("Create workbook failure", (Throwable)e);
        }
        WriteHandlerUtils.afterWorkbookCreate((WriteContext)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialization 'WriteContextImpl' complete");
        }
    }

    private void initCurrentWorkbookHolder(WriteWorkbook writeWorkbook) {
        this.writeWorkbookHolder = new WriteWorkbookHolder(writeWorkbook);
        this.currentWriteHolder = this.writeWorkbookHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeWorkbookHolder");
        }
    }

    public void currentSheet(WriteSheet writeSheet, WriteTypeEnum writeType) {
        Objects.requireNonNull(writeSheet, "Sheet argument cannot be null");
        if (this.selectSheetFromCache(writeSheet)) {
            return;
        }
        this.initCurrentSheetHolder(writeSheet);
        WriteHandlerUtils.beforeWorkbookCreate((WriteContext)this, (boolean)true);
        WriteHandlerUtils.afterWorkbookCreate((WriteContext)this, (boolean)true);
        this.initSheet(writeType);
    }

    private boolean selectSheetFromCache(WriteSheet writeSheet) {
        this.writeSheetHolder = null;
        if (writeSheet.getSheetNo() != null) {
            this.writeSheetHolder = (WriteSheetHolder)this.writeWorkbookHolder.getHasBeenInitializedSheetIndexMap().get(writeSheet.getSheetNo());
        }
        if (this.writeSheetHolder == null && !StringUtils.isEmpty((Object)writeSheet.getSheetName())) {
            this.writeSheetHolder = (WriteSheetHolder)this.writeWorkbookHolder.getHasBeenInitializedSheetNameMap().get(writeSheet.getSheetName());
        }
        if (this.writeSheetHolder == null) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sheet:{} is already existed", (Object)writeSheet.getSheetNo());
        }
        this.writeSheetHolder.setNewInitialization(Boolean.FALSE);
        this.currentWriteHolder = this.writeSheetHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeSheetHolder");
        }
        return true;
    }

    private void initCurrentSheetHolder(WriteSheet writeSheet) {
        this.writeSheetHolder = new WriteSheetHolder(writeSheet, this.writeWorkbookHolder);
        this.writeSheetHolder.setExcelWriteHeadProperty(this.currentWriteHolder.excelWriteHeadProperty());
        this.writeSheetHolder.setClazz(this.currentWriteHolder.excelWriteHeadProperty().getHeadClazz());
        this.currentWriteHolder = this.writeSheetHolder;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("CurrentConfiguration is writeSheetHolder");
        }
    }

    private void initSheet(WriteTypeEnum writeType) {
        Sheet currentSheet;
        WriteHandlerUtils.beforeSheetCreate((WriteContext)this);
        try {
            if (this.writeSheetHolder.getSheetNo() != null) {
                currentSheet = this.writeWorkbookHolder.getWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue());
                this.writeSheetHolder.setCachedSheet(this.writeWorkbookHolder.getCachedWorkbook().getSheetAt(this.writeSheetHolder.getSheetNo().intValue()));
            } else {
                currentSheet = this.writeWorkbookHolder.getWorkbook().getSheet(this.writeSheetHolder.getSheetName());
                this.writeSheetHolder.setCachedSheet(this.writeWorkbookHolder.getCachedWorkbook().getSheet(this.writeSheetHolder.getSheetName()));
            }
        }
        catch (Exception e) {
            LOGGER.info("initSheet method exception message:{}, deal with 'currentSheet = createSheet()'", (Object)e.getMessage());
            currentSheet = this.createSheet();
        }
        if (currentSheet == null) {
            currentSheet = this.createSheet();
        }
        this.writeSheetHolder.setSheet(currentSheet);
        WriteHandlerUtils.afterSheetCreate((WriteContext)this);
        if (WriteTypeEnum.ADD.equals((Object)writeType)) {
            this.initHead(this.writeSheetHolder.excelWriteHeadProperty());
        }
        this.writeWorkbookHolder.getHasBeenInitializedSheetIndexMap().put(this.writeSheetHolder.getSheetNo(), this.writeSheetHolder);
        this.writeWorkbookHolder.getHasBeenInitializedSheetNameMap().put(this.writeSheetHolder.getSheetName(), this.writeSheetHolder);
    }

    private Sheet createSheet() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Can not find sheet:{} ,now create it", (Object)this.writeSheetHolder.getSheetNo());
        }
        if (StringUtils.isEmpty((Object)this.writeSheetHolder.getSheetName())) {
            this.writeSheetHolder.setSheetName(this.writeSheetHolder.getSheetNo().toString());
        }
        Sheet currentSheet = WorkBookUtil.createSheet((Workbook)this.writeWorkbookHolder.getWorkbook(), (String)this.writeSheetHolder.getSheetName());
        this.writeSheetHolder.setCachedSheet(currentSheet);
        return currentSheet;
    }

    public void initHead(ExcelWriteHeadProperty excelWriteHeadProperty) {
        if (!this.currentWriteHolder.needHead() || !this.currentWriteHolder.excelWriteHeadProperty().hasHead()) {
            return;
        }
        int newRowIndex = this.writeSheetHolder.getNewRowIndexAndStartDoWrite();
        newRowIndex += this.currentWriteHolder.relativeHeadRowIndex();
        if (this.currentWriteHolder.automaticMergeHead()) {
            this.addMergedRegionToCurrentSheet(excelWriteHeadProperty, newRowIndex);
        }
        int relativeRowIndex = 0;
        int i = newRowIndex;
        while (i < excelWriteHeadProperty.getHeadRowNumber() + newRowIndex) {
            WriteHandlerUtils.beforeRowCreate((WriteContext)this, (Integer)newRowIndex, (Integer)relativeRowIndex, (Boolean)Boolean.TRUE);
            Row row = WorkBookUtil.createRow((Sheet)this.writeSheetHolder.getSheet(), (int)i);
            WriteHandlerUtils.afterRowCreate((WriteContext)this, (Row)row, (Integer)relativeRowIndex, (Boolean)Boolean.TRUE);
            this.addOneRowOfHeadDataToExcel(row, excelWriteHeadProperty.getHeadMap(), relativeRowIndex);
            WriteHandlerUtils.afterRowDispose((WriteContext)this, (Row)row, (Integer)relativeRowIndex, (Boolean)Boolean.TRUE);
            ++i;
            ++relativeRowIndex;
        }
    }

    private void addMergedRegionToCurrentSheet(ExcelWriteHeadProperty excelWriteHeadProperty, int rowIndex) {
        for (CellRange cellRangeModel : excelWriteHeadProperty.headCellRangeList()) {
            this.writeSheetHolder.getSheet().addMergedRegionUnsafe(new CellRangeAddress(cellRangeModel.getFirstRow() + rowIndex, cellRangeModel.getLastRow() + rowIndex, cellRangeModel.getFirstCol(), cellRangeModel.getLastCol()));
        }
    }

    private void addOneRowOfHeadDataToExcel(Row row, Map<Integer, Head> headMap, int relativeRowIndex) {
        for (Map.Entry<Integer, Head> entry : headMap.entrySet()) {
            Head head = entry.getValue();
            int columnIndex = entry.getKey();
            WriteHandlerUtils.beforeCellCreate((WriteContext)this, (Row)row, (Head)head, (Integer)columnIndex, (Integer)relativeRowIndex, (Boolean)Boolean.TRUE);
            Cell cell = row.createCell(columnIndex);
            WriteHandlerUtils.afterCellCreate((WriteContext)this, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.TRUE);
            cell.setCellValue((String)head.getHeadNameList().get(relativeRowIndex));
            WriteHandlerUtils.afterCellDispose((WriteContext)this, (CellData)null, (Cell)cell, (Head)head, (Integer)relativeRowIndex, (Boolean)Boolean.TRUE);
        }
    }

    public void currentTable(WriteTable writeTable) {
    }

    public WriteWorkbookHolder writeWorkbookHolder() {
        return this.writeWorkbookHolder;
    }

    public WriteSheetHolder writeSheetHolder() {
        return this.writeSheetHolder;
    }

    public WriteTableHolder writeTableHolder() {
        return null;
    }

    public WriteHolder currentWriteHolder() {
        return this.currentWriteHolder;
    }

    public void finish(boolean onException) {
        boolean writeExcel;
        if (this.finished) {
            return;
        }
        this.finished = true;
        WriteHandlerUtils.afterWorkbookDispose((WriteContext)this);
        if (this.writeWorkbookHolder == null) {
            return;
        }
        Throwable throwable = null;
        boolean isOutputStreamEncrypt = false;
        boolean bl = writeExcel = !onException;
        if (this.writeWorkbookHolder.getWriteExcelOnException().booleanValue()) {
            writeExcel = Boolean.TRUE;
        }
        if (writeExcel) {
            try {
                isOutputStreamEncrypt = this.doOutputStreamEncrypt07();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        if (!isOutputStreamEncrypt) {
            throwable = this.opWorkbook(throwable, writeExcel);
        }
        try {
            Workbook workbook = this.writeWorkbookHolder.getWorkbook();
            if (workbook instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)workbook).dispose();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (this.writeWorkbookHolder.getAutoCloseStream().booleanValue() && this.writeWorkbookHolder.getOutputStream() != null) {
                this.writeWorkbookHolder.getOutputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (writeExcel && !isOutputStreamEncrypt) {
            try {
                this.doFileEncrypt07();
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            if (this.writeWorkbookHolder.getTempTemplateInputStream() != null) {
                this.writeWorkbookHolder.getTempTemplateInputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.clearEncrypt03();
        this.removeThreadLocalCache();
        if (throwable != null) {
            throw new ExcelGenerateException("Can not close IO.", throwable);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished write.");
        }
    }

    private Throwable opWorkbook(Throwable throwable, boolean writeExcel) {
        try {
            if (writeExcel) {
                this.writeWorkbookHolder.getWorkbook().write(this.writeWorkbookHolder.getOutputStream());
            }
            this.writeWorkbookHolder.getWorkbook().close();
        }
        catch (Exception t) {
            throwable = t;
        }
        return throwable;
    }

    private void removeThreadLocalCache() {
        NumberDataFormatterUtils.removeThreadLocalCache();
        DateUtils.removeThreadLocalCache();
    }

    public Sheet getCurrentSheet() {
        return this.writeSheetHolder.getSheet();
    }

    public boolean needHead() {
        return this.writeSheetHolder.needHead();
    }

    public OutputStream getOutputStream() {
        return this.writeWorkbookHolder.getOutputStream();
    }

    public Workbook getWorkbook() {
        return this.writeWorkbookHolder.getWorkbook();
    }

    private void clearEncrypt03() {
        if (StringUtils.isEmpty((Object)this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLS.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return;
        }
        Biff8EncryptionKey.setCurrentUserPassword(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doOutputStreamEncrypt07() throws Exception {
        if (StringUtils.isEmpty((Object)this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLSX.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return false;
        }
        if (this.writeWorkbookHolder.getFile() != null) {
            return false;
        }
        File tempXlsx = FileUtils.createTmpFile((String)(UUID.randomUUID().toString() + ".xlsx"));
        Exception writeException = null;
        try (FileOutputStream tempFileOutputStream = new FileOutputStream(tempXlsx);){
            this.writeWorkbookHolder.getWorkbook().write((OutputStream)tempFileOutputStream);
        }
        catch (Exception e) {
            LOGGER.error("write excel error.", (Throwable)e);
        }
        finally {
            try {
                this.writeWorkbookHolder.getWorkbook().close();
            }
            catch (Exception e) {
                writeException = !tempXlsx.delete() ? new ExcelGenerateException("Can not delete temp File!") : e;
            }
        }
        if (writeException != null) {
            throw writeException;
        }
        ExcelGenerateException tempException = null;
        try (POIFSFileSystem fileSystem = this.openFileSystemAndEncrypt(tempXlsx);){
            fileSystem.writeFilesystem(this.writeWorkbookHolder.getOutputStream());
        }
        finally {
            if (!tempXlsx.delete()) {
                tempException = new ExcelGenerateException("Can not delete temp File!");
            }
        }
        if (tempException != null) {
            throw tempException;
        }
        return true;
    }

    private void doFileEncrypt07() throws Exception {
        if (StringUtils.isEmpty((Object)this.writeWorkbookHolder.getPassword()) || !ExcelTypeEnum.XLSX.equals((Object)this.writeWorkbookHolder.getExcelType())) {
            return;
        }
        if (this.writeWorkbookHolder.getFile() == null) {
            return;
        }
        try (POIFSFileSystem fileSystem = this.openFileSystemAndEncrypt(this.writeWorkbookHolder.getFile());
             FileOutputStream fileOutputStream = new FileOutputStream(this.writeWorkbookHolder.getFile());){
            fileSystem.writeFilesystem((OutputStream)fileOutputStream);
        }
    }

    private POIFSFileSystem openFileSystemAndEncrypt(File file) throws Exception {
        POIFSFileSystem fileSystem = new POIFSFileSystem();
        Encryptor encryptor = new EncryptionInfo(EncryptionMode.standard).getEncryptor();
        encryptor.confirmPassword(this.writeWorkbookHolder.getPassword());
        try (OPCPackage opcPackage = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ_WRITE);){
            OutputStream outputStream = encryptor.getDataStream(fileSystem);
            opcPackage.save(outputStream);
        }
        return fileSystem;
    }
}

