/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.transform;

import cn.com.yusys.yusp.commons.excelpdf.metadata.Excel;
import cn.com.yusys.yusp.commons.excelpdf.metadata.Pdf;
import cn.com.yusys.yusp.commons.excelpdf.transform.PdfEvent;
import cn.com.yusys.yusp.commons.excelpdf.transform.Sheet2PTable;
import cn.com.yusys.yusp.commons.excelpdf.transform.Transformer;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Sheet;

public class TransformerITextImpl
implements Transformer {
    private final Pdf pdf;
    private final Excel excel;
    private Document document;
    private PdfWriter writer;
    private float scale;

    public TransformerITextImpl(Pdf pdf, Excel excel, float scale) {
        Objects.requireNonNull(pdf, "The pdf can not be null");
        Objects.requireNonNull(excel, "The pdf excel not be null");
        this.pdf = pdf;
        this.excel = excel;
        this.scale = scale;
    }

    public void initTransformer(Sheet2PTable toPTable) {
        try {
            this.document = new Document();
            if (this.pdf.getPageSize() == null) {
                this.document.setPageSize(new Rectangle((float)toPTable.getMaxSheetWidth(), (float)toPTable.getMaxSheetHeight()));
            } else {
                this.document.setPageSize(this.pdf.getDirection() == Pdf.PdfDirection.VERTICAL ? this.pdf.getPageSize() : this.pdf.getPageSize().rotate());
            }
            this.document.setMargins(this.pdf.getContentMarginLeft(), this.pdf.getContentMarginRight(), this.pdf.getContentMarginTop(), this.pdf.getContentMarginBottom());
            this.writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.pdf.getOutputStream());
            this.writer.setPageEvent((PdfPageEvent)new PdfEvent(this.pdf));
            String password = this.pdf.getPassword();
            if (Objects.nonNull(password) && !password.isEmpty()) {
                this.writer.setEncryption(password.getBytes(), password.getBytes(), 512, 1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("init transformer error.", e);
        }
    }

    @Override
    public void transform() throws DocumentException {
        Sheet2PTable toPTable = new Sheet2PTable(this.excel, this.pdf, this.scale);
        this.initTransformer(toPTable);
        this.document.open();
        List<Sheet> sheetList = this.excel.getSheetList();
        int sheetNum = sheetList.size();
        for (int i = 0; i < sheetList.size(); ++i) {
            PdfPTable table = this.createTable(toPTable, sheetList.get(i));
            this.document.add((Element)table);
            if (i == sheetNum - 1) continue;
            this.document.newPage();
        }
        this.document.close();
        try {
            if (Objects.nonNull(this.writer)) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("can not close writer", e);
        }
        try {
            if (Objects.nonNull(this.pdf.getOutputStream())) {
                this.pdf.getOutputStream().close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("can not close pdf outputStream", e);
        }
        try {
            if (Objects.nonNull(this.excel.getInputStream())) {
                this.excel.getInputStream().close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("can not close excel inputStream", e);
        }
    }

    private PdfPTable createTable(Sheet2PTable toPTable, Sheet sheet) {
        float pdfHeight = this.document.top() - this.document.bottom();
        float pdfWidth = this.document.right() - this.document.left();
        PdfPTable pdfTable = toPTable.convertSheetToPdfTable(sheet, pdfWidth, pdfHeight);
        pdfTable.setKeepTogether(true);
        pdfTable.getDefaultCell().setBorder(0);
        return pdfTable;
    }
}

