/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.utils;

import java.util.Arrays;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class DateUtils {
    private DateUtils() {
    }

    public static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bDate = false;
        if (DateUtils.isValidExcelDate(cell.getNumericCellValue())) {
            CellStyle style = cell.getCellStyle();
            if (style == null) {
                return false;
            }
            short index = style.getDataFormat();
            String format = style.getDataFormatString();
            bDate = DateUtils.isADateFormat(index, format);
        }
        return bDate;
    }

    public static boolean isADateFormat(int formatIndex, String formatString) {
        if (DateUtils.isInternalDateFormat(formatIndex)) {
            return true;
        }
        if (formatString == null || formatString.isEmpty()) {
            return false;
        }
        String fs = formatString;
        fs = fs.replace("[\"|']", "").replace("[\u5e74|\u6708|\u65e5|\u65f6|\u5206|\u79d2|\u6beb\u79d2|\u5fae\u79d2]", "");
        fs = fs.replace("\\\\-", "-");
        fs = fs.replace("\\\\,", ",");
        fs = fs.replace("\\\\.", ".");
        fs = fs.replace("\\\\ ", " ");
        fs = fs.replace(";@", "");
        fs = fs.replace("^\\[\\$\\-.*?\\]", "");
        fs = fs.replace("^\\[[a-zA-Z]+\\]", "");
        return fs.matches("^[yYmMdDhHsS\\-/,. :]+[ampAMP/]*$");
    }

    public static boolean isInternalDateFormat(int format) {
        return Arrays.asList(14, 15, 16, 17, 18, 19, 20, 21, 22, 45, 46, 47).contains(format);
    }

    public static boolean isValidExcelDate(double value) {
        return value > -4.9E-324;
    }
}

