/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf.utils;

import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;

public class ExcelColorUtils {
    private static final short NO_COLOR = IndexedColors.AUTOMATIC.getIndex();
    private final Workbook workbook;

    public ExcelColorUtils(Workbook workbook) {
        this.workbook = workbook;
    }

    public int[] getFillBackgroundColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        if (style instanceof XSSFCellStyle) {
            return ExcelColorUtils.getColor(style.getFillBackgroundColorColor());
        }
        return this.getColor(style.getFillBackgroundColor());
    }

    public int[] getFillForegroundColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        if (style instanceof XSSFCellStyle) {
            return ExcelColorUtils.getColor(style.getFillForegroundColorColor());
        }
        return this.getColor(style.getFillForegroundColor());
    }

    public int[] getLeftBorderColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xcs = (XSSFCellStyle)style;
            return ExcelColorUtils.getColor((Color)xcs.getBorderColor(XSSFCellBorder.BorderSide.LEFT));
        }
        return this.getColor(style.getLeftBorderColor());
    }

    public int[] getRightBorderColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xcs = (XSSFCellStyle)style;
            return ExcelColorUtils.getColor((Color)xcs.getBorderColor(XSSFCellBorder.BorderSide.RIGHT));
        }
        return this.getColor(style.getRightBorderColor());
    }

    public int[] getTopBorderColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xcs = (XSSFCellStyle)style;
            return ExcelColorUtils.getColor((Color)xcs.getBorderColor(XSSFCellBorder.BorderSide.TOP));
        }
        return this.getColor(style.getTopBorderColor());
    }

    public int[] getBottomBorderColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xcs = (XSSFCellStyle)style;
            return ExcelColorUtils.getColor((Color)xcs.getBorderColor(XSSFCellBorder.BorderSide.BOTTOM));
        }
        return this.getColor(style.getBottomBorderColor());
    }

    public int[] getFontColor(Cell cell) {
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return new int[0];
        }
        return this.getFontColor(this.workbook.getFontAt(style.getFontIndexAsInt()));
    }

    public int[] getFontColor(Font font) {
        return font instanceof XSSFFont ? ExcelColorUtils.getColor((Color)((XSSFFont)font).getXSSFColor()) : this.getColor(font.getColor());
    }

    private static int[] getColor(Color c) {
        int[] colorArray = new int[4];
        if (c == null) {
            return new int[0];
        }
        if (c instanceof HSSFColor) {
            HSSFColor hc = (HSSFColor)c;
            short[] rgb = hc.getTriplet();
            colorArray[0] = rgb[0];
            colorArray[1] = rgb[1];
            colorArray[2] = rgb[2];
            colorArray[3] = 255;
        } else if (c instanceof XSSFColor) {
            XSSFColor xc = (XSSFColor)c;
            byte[] data = xc.getTint() != 0.0 ? ExcelColorUtils.getRgbWithTint(xc) : xc.getARGB();
            if (data == null) {
                return new int[0];
            }
            int idx = 0;
            int alpha = 255;
            if (data.length == 4) {
                alpha = data[idx++] & 0xFF;
            }
            int r = data[idx++] & 0xFF;
            int g = data[idx++] & 0xFF;
            int b = data[idx++] & 0xFF;
            colorArray[0] = r;
            colorArray[1] = g;
            colorArray[2] = b;
            colorArray[3] = alpha;
        } else {
            throw new IllegalStateException();
        }
        return colorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getColor(short colorIndex) {
        if (colorIndex == NO_COLOR) {
            return null;
        }
        CellStyle style = this.workbook.getCellStyleAt(0);
        short temp = style.getFillForegroundColor();
        try {
            style.setFillForegroundColor(colorIndex);
            Color c = style.getFillForegroundColorColor();
            int[] nArray = ExcelColorUtils.getColor(c);
            return nArray;
        }
        finally {
            style.setFillForegroundColor(temp);
        }
    }

    private static byte[] getRgbWithTint(XSSFColor c) {
        byte[] rgb = c.getCTColor().getRgb();
        double tint = c.getTint();
        if (rgb != null && tint != 0.0) {
            if (rgb.length == 4) {
                byte[] tmp = new byte[3];
                System.arraycopy(rgb, 1, tmp, 0, 3);
                rgb = tmp;
            }
            for (int i = 0; i < rgb.length; ++i) {
                int lum = rgb[i] & 0xFF;
                double d = ExcelColorUtils.sRGB_to_scRGB((double)lum / 255.0);
                d = tint > 0.0 ? d * (1.0 - tint) + tint : d * (1.0 + tint);
                d = ExcelColorUtils.scRGB_to_sRGB(d);
                rgb[i] = (byte)Math.round(d * 255.0);
            }
        }
        return rgb;
    }

    private static double sRGB_to_scRGB(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value <= 0.04045) {
            return value / 12.92;
        }
        if (value <= 1.0) {
            return Math.pow((value + 0.055) / 1.055, 2.4);
        }
        return 1.0;
    }

    private static double scRGB_to_sRGB(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value <= 0.0031308) {
            return value * 12.92;
        }
        if (value < 1.0) {
            return 1.055 * Math.pow(value, 0.4166666666666667) - 0.055;
        }
        return 1.0;
    }
}

