/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.excelpdf;

import cn.com.yusys.yusp.commons.excelpdf.metadata.WaterMarker;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.springframework.util.ResourceUtils;

public class PdfWaterMarker {
    private PdfWaterMarker() {
    }

    public static void markImgToPdf(String inPdfFile, File outPdfFile, String password, WaterMarker waterMarker) {
        try {
            PdfWaterMarker.markImgToPdf(ResourceUtils.getURL((String)inPdfFile), outPdfFile, password, waterMarker);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("can not convert.", e);
        }
    }

    public static void markImgToPdf(URL inPdfFile, File outPdfFile, String password, WaterMarker waterMarker) {
        try {
            byte[] imgBytes;
            PdfReader reader = Objects.isNull(password) || password.isEmpty() ? new PdfReader(inPdfFile) : new PdfReader(inPdfFile, password.getBytes());
            Rectangle pageSize = reader.getPageSize(1);
            float pdfWidth = reader.getPageRotation(1) == 90 ? pageSize.getHeight() : pageSize.getWidth();
            float pdfHeight = reader.getPageRotation(1) == 90 ? pageSize.getWidth() : pageSize.getHeight();
            PdfStamper pdfStamper = new PdfStamper(reader, (OutputStream)new FileOutputStream(outPdfFile));
            PdfGState pdfState = new PdfGState();
            pdfState.setFillOpacity(waterMarker.getOpacity());
            try (FileInputStream inputStream = new FileInputStream(waterMarker.getFile());){
                imgBytes = IOUtils.toByteArray((InputStream)inputStream);
            }
            Image img = Image.getInstance((byte[])imgBytes);
            PdfWaterMarker.setImage(waterMarker, pdfWidth, pdfHeight, img);
            int pageNum = reader.getNumberOfPages();
            if (waterMarker.isEachPage()) {
                PdfWaterMarker.addTemplate1(waterMarker, pdfStamper, pdfState, img, pageNum);
            } else if (waterMarker.getAssignPage() != null && waterMarker.getAssignPage().length > 0) {
                PdfWaterMarker.addTemplate2(waterMarker, pdfStamper, pdfState, img, pageNum);
            } else {
                PdfContentByte template = waterMarker.isBelowContent() ? pdfStamper.getUnderContent(pageNum) : pdfStamper.getOverContent(pageNum);
                template.setGState(pdfState);
                template.addImage(img);
            }
            pdfStamper.close();
            reader.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("can not convert.", e);
        }
    }

    private static void addTemplate2(WaterMarker waterMarker, PdfStamper pdfStamper, PdfGState pdfState, Image img, int pageNum) throws DocumentException {
        for (int index : waterMarker.getAssignPage()) {
            if (index > pageNum || index <= 0) continue;
            PdfContentByte template = waterMarker.isBelowContent() ? pdfStamper.getUnderContent(index) : pdfStamper.getOverContent(index);
            template.setGState(pdfState);
            template.addImage(img);
        }
    }

    private static void addTemplate1(WaterMarker waterMarker, PdfStamper pdfStamper, PdfGState pdfState, Image img, int pageNum) throws DocumentException {
        for (int i = 1; i <= pageNum; ++i) {
            PdfContentByte template = waterMarker.isBelowContent() ? pdfStamper.getUnderContent(i) : pdfStamper.getOverContent(i);
            template.setGState(pdfState);
            template.addImage(img);
        }
    }

    private static void setImage(WaterMarker waterMarker, float pdfWidth, float pdfHeight, Image img) {
        if (waterMarker.getCustomWidth() != 0.0f && waterMarker.getCustomHeight() != 0.0f) {
            img.scaleAbsolute(waterMarker.getCustomWidth(), waterMarker.getCustomHeight());
        }
        if (waterMarker.getScale() != 100.0f) {
            img.scalePercent(waterMarker.getScale());
        }
        float positionX = pdfWidth - img.getScaledWidth();
        float positionY = 0.0f;
        if (waterMarker.getAwayFromLeftPercent() != 0.0f && waterMarker.getAwayFromTopPercent() != 0.0f) {
            positionX = pdfWidth * (waterMarker.getAwayFromLeftPercent() / 100.0f) - img.getScaledWidth() / 2.0f;
            positionY = pdfHeight - pdfHeight * (waterMarker.getAwayFromTopPercent() / 100.0f) - img.getScaledHeight() / 2.0f;
        } else if (waterMarker.getPositionX() > 0.0f && waterMarker.getPositionY() > 0.0f) {
            positionX = waterMarker.getPositionX();
            positionY = waterMarker.getPositionY();
        }
        positionX = positionX > pdfWidth ? pdfWidth - img.getScaledWidth() : positionX;
        positionY = positionY > pdfHeight ? pdfHeight - img.getScaledHeight() : positionY;
        img.setAbsolutePosition(positionX, positionY);
        img.setRotation(waterMarker.getRotation());
        img.setRotationDegrees(waterMarker.getRotationDegrees());
    }
}

